/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.minecraft.world.entity.LivingEntity;

public class CMoonInversionAction
extends MoveAction<CMoonInversionAction, CMoonEntity> {
    private final int time;
    private final float damage;
    private final boolean slow;

    @Override
    public void perform(CMoonEntity attacker, LivingEntity user, Set<LivingEntity> targets) {
        targets.forEach(t -> attacker.addInversion((LivingEntity)t, this.time, this.damage, this.slow));
    }

    @Override
    @NonNull
    public MoveActionType<CMoonInversionAction> getType() {
        return Type.INSTANCE;
    }

    public int getTime() {
        return this.time;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean isSlow() {
        return this.slow;
    }

    private CMoonInversionAction(int time, float damage, boolean slow) {
        this.time = time;
        this.damage = damage;
        this.slow = slow;
    }

    public static CMoonInversionAction addInversion(int time, float damage, boolean slow) {
        return new CMoonInversionAction(time, damage, slow);
    }

    public static class Type
    extends MoveActionType<CMoonInversionAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<CMoonInversionAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)Codec.INT.fieldOf("time").forGetter(CMoonInversionAction::getTime), (App)Codec.FLOAT.fieldOf("damage").forGetter(CMoonInversionAction::getDamage), (App)Codec.BOOL.fieldOf("slow").forGetter(CMoonInversionAction::isSlow)).apply((Applicative)instance, this.apply(CMoonInversionAction::addInversion)));
        }
    }
}

