/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.LivingEntity;

public class CancelSpecMoveAction
extends MoveAction<CancelSpecMoveAction, StandEntity<?, ?>> {
    @Override
    public void perform(StandEntity<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        JSpec<?, ?> spec = JUtils.getSpec(user);
        if (spec != null && spec.getCurrentMove() != null) {
            spec.cancelMove();
        }
    }

    @Override
    @NonNull
    public MoveActionType<CancelSpecMoveAction> getType() {
        return Type.INSTANCE;
    }

    private CancelSpecMoveAction() {
    }

    public static CancelSpecMoveAction cancelSpecMove() {
        return new CancelSpecMoveAction();
    }

    public static class Type
    extends MoveActionType<CancelSpecMoveAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<CancelSpecMoveAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment()).apply((Applicative)instance, this.apply(CancelSpecMoveAction::new)));
        }
    }
}

