/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.common.util.JCodecUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class EffectAction
extends MoveAction<EffectAction, IAttacker<?, ?>> {
    private final List<Supplier<MobEffectInstance>> effects;

    public static EffectAction inflict(MobEffect effect, int duration, int amplifier) {
        return EffectAction.inflict(new MobEffectInstance(effect, duration, amplifier));
    }

    public static EffectAction inflict(MobEffect effect, int duration, int amplifier, boolean ambient, boolean visible) {
        return EffectAction.inflict(new MobEffectInstance(effect, duration, amplifier, ambient, visible));
    }

    public static EffectAction inflict(MobEffect effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        return EffectAction.inflict(new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon));
    }

    public static EffectAction inflict(Supplier<MobEffect> effect, int duration, int amplifier) {
        return EffectAction.inflict(() -> new MobEffectInstance((MobEffect)effect.get(), duration, amplifier));
    }

    public static EffectAction inflict(Supplier<MobEffect> effect, int duration, int amplifier, boolean ambient, boolean visible) {
        return EffectAction.inflict(() -> new MobEffectInstance((MobEffect)effect.get(), duration, amplifier, ambient, visible));
    }

    public static EffectAction inflict(Supplier<MobEffect> effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        return EffectAction.inflict(() -> new MobEffectInstance((MobEffect)effect.get(), duration, amplifier, ambient, visible, showIcon));
    }

    public static EffectAction inflict(MobEffectInstance effect) {
        return new SingleEffectAction(() -> effect);
    }

    public static EffectAction inflict(MobEffectInstance ... effects) {
        return effects.length == 1 ? new SingleEffectAction((Supplier<MobEffectInstance>)Suppliers.memoize(() -> effects[0])) : new EffectAction(Stream.of(effects).map(inst -> () -> inst).toList());
    }

    public static EffectAction inflict(Supplier<MobEffectInstance> effect) {
        return new SingleEffectAction(effect);
    }

    public static EffectAction inflict(Collection<Supplier<MobEffectInstance>> effects) {
        return effects.size() == 1 ? new SingleEffectAction(effects.iterator().next()) : new EffectAction((List<Supplier<MobEffectInstance>>)ImmutableList.copyOf(effects));
    }

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        for (LivingEntity target : targets) {
            this.effects.stream().map(Supplier::get).map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)target).m_7292_(arg_0));
        }
    }

    @Override
    @NonNull
    public MoveActionType<EffectAction> getType() {
        return Type.INSTANCE;
    }

    public List<Supplier<MobEffectInstance>> getEffects() {
        return this.effects;
    }

    private EffectAction(List<Supplier<MobEffectInstance>> effects) {
        this.effects = effects;
    }

    private static class SingleEffectAction
    extends EffectAction {
        private final Supplier<MobEffectInstance> effect;

        public SingleEffectAction(Supplier<MobEffectInstance> effect) {
            super((List<Supplier<MobEffectInstance>>)ImmutableList.of(effect));
            this.effect = effect;
        }

        @Override
        public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
            for (LivingEntity target : targets) {
                target.m_7292_(new MobEffectInstance(this.effect.get()));
            }
        }
    }

    public static class Type
    extends MoveActionType<EffectAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<EffectAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)JCodecUtils.MOB_EFFECT_INSTANCE_CODEC.listOf().fieldOf("effects").forGetter(a -> a.getEffects().stream().map(Supplier::get).toList())).apply((Applicative)instance, this.apply((T1 effects) -> EffectAction.inflict((MobEffectInstance[])effects.toArray(MobEffectInstance[]::new)))));
        }
    }
}

