/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;

public class LightOnFireAction
extends MoveAction<LightOnFireAction, IAttacker<?, ?>> {
    private final int duration;
    private boolean ignoreProtection;

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        for (LivingEntity target : targets) {
            int duration = this.duration;
            if (!this.ignoreProtection) {
                duration = ProtectionEnchantment.m_45138_((LivingEntity)target, (int)duration);
            }
            if (duration <= target.m_20094_()) continue;
            target.m_7311_(duration);
        }
    }

    @Override
    @NonNull
    public MoveActionType<LightOnFireAction> getType() {
        return Type.INSTANCE;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isIgnoreProtection() {
        return this.ignoreProtection;
    }

    private LightOnFireAction(int duration, boolean ignoreProtection) {
        this.duration = duration;
        this.ignoreProtection = ignoreProtection;
    }

    public static LightOnFireAction lightOnFire(int duration, boolean ignoreProtection) {
        return new LightOnFireAction(duration, ignoreProtection);
    }

    private LightOnFireAction(int duration) {
        this.duration = duration;
    }

    public static LightOnFireAction lightOnFire(int duration) {
        return new LightOnFireAction(duration);
    }

    public static final class Type
    extends MoveActionType<LightOnFireAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<LightOnFireAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)ExtraCodecs.f_144629_.fieldOf("duration").forGetter(LightOnFireAction::getDuration), (App)Codec.BOOL.optionalFieldOf("ignore_protection", (Object)false).forGetter(LightOnFireAction::isIgnoreProtection)).apply((Applicative)instance, this.apply((T1 duration, T2 ignoreProtection) -> LightOnFireAction.lightOnFire(duration, ignoreProtection))));
        }

        private Type() {
        }
    }
}

