/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LungeAction
extends MoveAction<LungeAction, IAttacker<?, ?>> {
    private final float factor;
    private final float verticalFactor;
    private boolean onGround = false;
    private boolean notFree = false;

    public LungeAction onGround() {
        this.onGround = true;
        return this;
    }

    public LungeAction isNotFree() {
        this.notFree = true;
        return this;
    }

    public boolean requireOnGround() {
        return this.onGround;
    }

    public boolean requireNotFree() {
        return this.notFree;
    }

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        StandEntity stand;
        if (this.onGround && !user.m_20096_() || this.notFree && attacker instanceof StandEntity && (stand = (StandEntity)attacker).isFree()) {
            return;
        }
        JUtils.addVelocity((Entity)user, attacker.getBaseEntity().m_20154_().m_82490_((double)this.factor).m_82520_(0.0, (double)this.verticalFactor, 0.0));
    }

    @Override
    @NonNull
    public MoveActionType<LungeAction> getType() {
        return Type.INSTANCE;
    }

    private LungeAction(float factor, float verticalFactor, boolean onGround, boolean notFree) {
        this.factor = factor;
        this.verticalFactor = verticalFactor;
        this.onGround = onGround;
        this.notFree = notFree;
    }

    private LungeAction(float factor, float verticalFactor) {
        this.factor = factor;
        this.verticalFactor = verticalFactor;
    }

    public static LungeAction lunge(float factor, float verticalFactor) {
        return new LungeAction(factor, verticalFactor);
    }

    public float getFactor() {
        return this.factor;
    }

    public float getVerticalFactor() {
        return this.verticalFactor;
    }

    public static class Type
    extends MoveActionType<LungeAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<LungeAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)Codec.FLOAT.fieldOf("factor").forGetter(LungeAction::getFactor), (App)Codec.FLOAT.fieldOf("vertical_factor").forGetter(LungeAction::getVerticalFactor), (App)Codec.BOOL.optionalFieldOf("on_ground", (Object)false).forGetter(LungeAction::requireOnGround), (App)Codec.BOOL.optionalFieldOf("not_free", (Object)false).forGetter(LungeAction::requireNotFree)).apply((Applicative)instance, this.apply((factor, verticalFactor, onGround, notFree) -> new LungeAction(factor.floatValue(), verticalFactor.floatValue()))));
        }
    }
}

