/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.minecraft.world.entity.LivingEntity;

public class MetallicaAddIronAction
extends MoveAction<MetallicaAddIronAction, MetallicaEntity> {
    private final float iron;

    @Override
    public void perform(MetallicaEntity attacker, LivingEntity user, Set<LivingEntity> targets) {
        attacker.addIron(this.iron);
    }

    @Override
    @NonNull
    public MoveActionType<MetallicaAddIronAction> getType() {
        return Type.INSTANCE;
    }

    public float getIron() {
        return this.iron;
    }

    private MetallicaAddIronAction(float iron) {
        this.iron = iron;
    }

    public static MetallicaAddIronAction addIron(float iron) {
        return new MetallicaAddIronAction(iron);
    }

    public static class Type
    extends MoveActionType<MetallicaAddIronAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<MetallicaAddIronAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)Codec.FLOAT.fieldOf("iron").forGetter(MetallicaAddIronAction::getIron)).apply((Applicative)instance, this.apply(MetallicaAddIronAction::addIron)));
        }
    }
}

