/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.api.attack.core.RunMoment;
import net.arna.jcraft.common.util.JCodecUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

public class PlaySoundAction
extends MoveAction<PlaySoundAction, IAttacker<?, ?>> {
    private final Supplier<SoundEvent> sound;
    private final float minVol;
    private final float maxVol;
    private final float minPitch;
    private final float maxPitch;

    private PlaySoundAction(Supplier<SoundEvent> sound, float minVol, float maxVol, float minPitch, float maxPitch, boolean onImpact) {
        this.sound = sound;
        this.minVol = minVol;
        this.maxVol = maxVol;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
        if (onImpact) {
            this.setRunMoment(RunMoment.ON_HIT);
        }
    }

    public static PlaySoundAction playSound(SoundEvent sound) {
        return PlaySoundAction.playSound(sound, 1.0f, 1.0f);
    }

    public static PlaySoundAction playSound(SoundEvent sound, float volume, float pitch) {
        return PlaySoundAction.playSound(sound, volume, volume, pitch, pitch);
    }

    public static PlaySoundAction playSound(SoundEvent sound, float volMin, float volMax, float pitchMin, float pitchMax) {
        return new PlaySoundAction(() -> sound, volMin, volMax, pitchMin, pitchMax, false);
    }

    public static PlaySoundAction playSound(RegistrySupplier<SoundEvent> sound) {
        return PlaySoundAction.playSound(sound, 1.0f, 1.0f);
    }

    public static PlaySoundAction playSound(RegistrySupplier<SoundEvent> sound, float volume, float pitch) {
        return PlaySoundAction.playSound(sound, volume, volume, pitch, pitch);
    }

    public static PlaySoundAction playSound(RegistrySupplier<SoundEvent> sound, float volMin, float volMax, float pitchMin, float pitchMax) {
        return new PlaySoundAction((Supplier<SoundEvent>)sound, volMin, volMax, pitchMin, pitchMax, false);
    }

    public static PlaySoundAction playImpactSound(SoundEvent sound) {
        return PlaySoundAction.playImpactSound(sound, 1.0f, 1.0f);
    }

    public static PlaySoundAction playImpactSound(SoundEvent sound, float volume, float pitch) {
        return PlaySoundAction.playImpactSound(sound, volume, volume, pitch, pitch);
    }

    public static PlaySoundAction playImpactSound(SoundEvent sound, float volMin, float volMax, float pitchMin, float pitchMax) {
        return new PlaySoundAction(() -> sound, volMin, volMax, pitchMin, pitchMax, true);
    }

    public static PlaySoundAction playImpactSound(RegistrySupplier<SoundEvent> sound) {
        return PlaySoundAction.playImpactSound(sound, 1.0f, 1.0f);
    }

    public static PlaySoundAction playImpactSound(RegistrySupplier<SoundEvent> sound, float volume, float pitch) {
        return PlaySoundAction.playImpactSound(sound, volume, volume, pitch, pitch);
    }

    public static PlaySoundAction playImpactSound(RegistrySupplier<SoundEvent> sound, float volMin, float volMax, float pitchMin, float pitchMax) {
        return new PlaySoundAction((Supplier<SoundEvent>)sound, volMin, volMax, pitchMin, pitchMax, true);
    }

    public PlaySoundAction onImpact() {
        return new PlaySoundAction(this.sound, this.minVol, this.maxVol, this.minPitch, this.maxPitch, true);
    }

    private static float randomize(RandomSource random, float min, float max) {
        return min + (max - min) * random.m_188501_();
    }

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        attacker.playAttackerSound(this.sound.get(), PlaySoundAction.randomize(attacker.getBaseEntity().m_217043_(), this.minVol, this.maxVol), PlaySoundAction.randomize(attacker.getBaseEntity().m_217043_(), this.minPitch, this.maxPitch));
    }

    @Override
    @NonNull
    public MoveActionType<PlaySoundAction> getType() {
        return Type.INSTANCE;
    }

    public Supplier<SoundEvent> getSound() {
        return this.sound;
    }

    public float getMinVol() {
        return this.minVol;
    }

    public float getMaxVol() {
        return this.maxVol;
    }

    public float getMinPitch() {
        return this.minPitch;
    }

    public float getMaxPitch() {
        return this.maxPitch;
    }

    public static class Type
    extends MoveActionType<PlaySoundAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<PlaySoundAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)JCodecUtils.SOUND_EVENT_SUPPLIER_CODEC.fieldOf("sound").forGetter(PlaySoundAction::getSound), (App)Codec.FLOAT.optionalFieldOf("min_vol", (Object)Float.valueOf(1.0f)).forGetter(PlaySoundAction::getMinVol), (App)Codec.FLOAT.optionalFieldOf("max_vol", (Object)Float.valueOf(1.0f)).forGetter(PlaySoundAction::getMaxVol), (App)Codec.FLOAT.optionalFieldOf("min_pitch", (Object)Float.valueOf(1.0f)).forGetter(PlaySoundAction::getMinPitch), (App)Codec.FLOAT.optionalFieldOf("max_pitch", (Object)Float.valueOf(1.0f)).forGetter(PlaySoundAction::getMaxPitch)).apply((Applicative)instance, this.apply((sound, minVol, maxVol, minPitch, maxPitch) -> new PlaySoundAction((Supplier<SoundEvent>)sound, minVol.floatValue(), maxVol.floatValue(), minPitch.floatValue(), maxPitch.floatValue(), false))));
        }
    }
}

