/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RunCommandAction
extends MoveAction<RunCommandAction, IAttacker<?, ?>> {
    private final String command;

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        MinecraftServer server = attacker.getEntityWorld().m_7654_();
        if (server == null) {
            return;
        }
        CommandSourceStack source = server.m_129893_();
        if (user != null) {
            source = source.m_81329_((Entity)user).m_81348_(user.m_20182_());
        }
        try {
            server.m_129892_().m_82094_().execute(this.command, (Object)source);
        }
        catch (CommandSyntaxException e) {
            if (user != null) {
                user.m_213846_((Component)Component.m_237113_((String)"An unknown error occurred while executing a 'Run Command' action. Check the console for details.").m_130940_(ChatFormatting.RED));
            }
            JCraft.LOGGER.error("An error occurred while executing command '{}' for a RunCommand action.", (Object)this.command, (Object)e);
        }
    }

    @Override
    @NonNull
    public MoveActionType<RunCommandAction> getType() {
        return Type.INSTANCE;
    }

    public String getCommand() {
        return this.command;
    }

    private RunCommandAction(String command) {
        this.command = command;
    }

    public static RunCommandAction run(String command) {
        return new RunCommandAction(command);
    }

    public static class Type
    extends MoveActionType<RunCommandAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<RunCommandAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)Codec.STRING.fieldOf("command").forGetter(RunCommandAction::getCommand)).apply((Applicative)instance, this.apply(RunCommandAction::run)));
        }
    }
}

