/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.common.util.JCodecUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;

public class ScoreboardAction
extends MoveAction<ScoreboardAction, IAttacker<?, ?>> {
    private final String objective;
    private final ScoreboardActionType actionType;
    private final int value;

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        MinecraftServer server = attacker.getEntityWorld().m_7654_();
        if (server == null) {
            return;
        }
        ServerScoreboard scoreboard = server.m_129896_();
        Objective objective = scoreboard.m_83469_(this.objective);
        Score score = scoreboard.m_83471_(user.m_6302_(), objective);
        switch (this.actionType.ordinal()) {
            case 0: {
                score.m_83402_(score.m_83400_() + this.value);
                break;
            }
            case 1: {
                score.m_83402_(score.m_83400_() * this.value);
                break;
            }
            case 2: {
                score.m_83402_(this.value);
            }
        }
    }

    @Override
    @NonNull
    public MoveActionType<ScoreboardAction> getType() {
        return Type.INSTANCE;
    }

    public String getObjective() {
        return this.objective;
    }

    public ScoreboardActionType getActionType() {
        return this.actionType;
    }

    public int getValue() {
        return this.value;
    }

    private ScoreboardAction(String objective, ScoreboardActionType actionType, int value) {
        this.objective = objective;
        this.actionType = actionType;
        this.value = value;
    }

    public static ScoreboardAction of(String objective, ScoreboardActionType actionType, int value) {
        return new ScoreboardAction(objective, actionType, value);
    }

    public static enum ScoreboardActionType {
        ADD("add"),
        MULTIPLY("multiply"),
        SET("set");

        private final String name;

        private ScoreboardActionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Type
    extends MoveActionType<ScoreboardAction> {
        public static final Type INSTANCE = new Type();
        private final Codec<ScoreboardAction> codec = RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreboardAction::getObjective), (App)JCodecUtils.createEnumCodec(ScoreboardActionType.class).fieldOf("actionType").forGetter(ScoreboardAction::getActionType), (App)Codec.INT.fieldOf("value").forGetter(ScoreboardAction::getValue)).apply((Applicative)instance, this.apply(ScoreboardAction::of)));

        @Override
        public Codec<ScoreboardAction> getCodec() {
            return this.codec;
        }
    }
}

