/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveActionType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.LivingEntity;

public class UserAnimationAction
extends MoveAction<UserAnimationAction, IAttacker<?, ?>> {
    private final String animation;
    private boolean force = false;

    public UserAnimationAction force() {
        return new UserAnimationAction(this.animation, true);
    }

    @Override
    public void perform(IAttacker<?, ?> attacker, LivingEntity user, Set<LivingEntity> targets) {
        if (this.force) {
            JUtils.playAnim(user, this.animation);
        } else {
            JUtils.playAnimIfUnoccupied(user, this.animation);
        }
    }

    @Override
    @NonNull
    public MoveActionType<UserAnimationAction> getType() {
        return Type.INSTANCE;
    }

    public String getAnimation() {
        return this.animation;
    }

    public boolean isForce() {
        return this.force;
    }

    private UserAnimationAction(String animation, boolean force) {
        this.animation = animation;
        this.force = force;
    }

    private UserAnimationAction(String animation) {
        this.animation = animation;
    }

    public static UserAnimationAction play(String animation) {
        return new UserAnimationAction(animation);
    }

    public static class Type
    extends MoveActionType<UserAnimationAction> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<UserAnimationAction> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group(this.runMoment(), (App)Codec.STRING.fieldOf("animation").forGetter(UserAnimationAction::getAnimation), (App)Codec.BOOL.optionalFieldOf("force", (Object)false).forGetter(UserAnimationAction::isForce)).apply((Applicative)instance, this.apply((T1 anim, T2 force) -> new UserAnimationAction((String)anim, (boolean)force))));
        }
    }
}

