/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.arna.jcraft.api.attack.core.MoveCondition;
import net.arna.jcraft.api.attack.core.MoveConditionType;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import org.jetbrains.annotations.NotNull;

public class MetallicaIronCondition
extends MoveCondition<MetallicaIronCondition, MetallicaEntity> {
    private final float requiredIron;

    private MetallicaIronCondition(float minIron) {
        this.requiredIron = minIron;
    }

    public static MetallicaIronCondition atLeast(float minIron) {
        return new MetallicaIronCondition(minIron);
    }

    @Override
    public boolean test(MetallicaEntity attacker) {
        return attacker.getIron() >= this.requiredIron;
    }

    @Override
    @NotNull
    public MoveConditionType<MetallicaIronCondition> getType() {
        return Type.INSTANCE;
    }

    public float getRequiredIron() {
        return this.requiredIron;
    }

    public static class Type
    implements MoveConditionType<MetallicaIronCondition> {
        public static final Type INSTANCE = new Type();

        @Override
        public Codec<MetallicaIronCondition> getCodec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_iron").forGetter(MetallicaIronCondition::getRequiredIron)).apply((Applicative)instance, MetallicaIronCondition::new));
        }
    }
}

