/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.util.CooldownType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveMapImpl<A extends IAttacker<? extends A, S>, S extends Enum<?>>
implements MoveMap<A, S> {
    private final ListMultimap<MoveClass, MoveMap.Entry<A, S>> entries = MultimapBuilder.enumKeys(MoveClass.class).arrayListValues().build();
    private List<AbstractMove<?, ? super A>> allMoves;
    private boolean frozen = false;

    public MoveMapImpl(Collection<MoveMap.Entry<A, S>> entries) {
        entries.forEach(entry -> this.entries.put((Object)entry.getMoveClass(), entry));
        this.freeze();
    }

    @Override
    public EntryImpl<A, S> register(@NonNull MoveClass type, @NonNull AbstractMove<?, ? super A> move) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        return this.register(type, move, null);
    }

    @Override
    public EntryImpl<A, S> register(@NonNull MoveClass type, @NonNull AbstractMove<?, ? super A> move, @Nullable S animState) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        return this.register(type, (AbstractMove)move, type.getDefaultCooldownType(), (Enum)animState);
    }

    @Override
    public void registerImmediate(@NonNull MoveClass type, @NonNull AbstractMove<?, ? super A> move, @Nullable S animState) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        MoveMap.Entry entry = this.register(type, (AbstractMove)move, (Enum)animState);
        this.copyAnims(entry);
    }

    private void copyAnims(MoveMap.Entry<A, S> entry) {
        AbstractMove<?, A> move = entry.getMove();
        if (move.getCrouchingVariant() != null) {
            MoveMap.Entry<A, Enum<?>> cr = entry.withCrouchingVariant(move.getCrouchingVariant().getAnimation());
            this.copyAnims(cr);
        }
        if (move.getAerialVariant() != null) {
            MoveMap.Entry<A, Enum<?>> ae = entry.withAerialVariant(move.getAerialVariant().getAnimation());
            this.copyAnims(ae);
        }
        if (move.getFollowup() != null) {
            MoveMap.Entry<A, Enum<?>> fw = entry.withFollowup(move.getFollowup().getAnimation());
            this.copyAnims(fw);
        }
    }

    @Override
    public EntryImpl<A, S> register(@NonNull MoveClass type, @NonNull AbstractMove<?, ? super A> move, @Nullable CooldownType cooldownType, @Nullable S animState) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        this.checkFrozen();
        Object copy = move.copy();
        if (copy == null) {
            throw new IllegalStateException(move.getClass().getSimpleName() + "#copy() returned null.");
        }
        ((AbstractMove)copy).onRegister(type);
        EntryImpl entry = new EntryImpl(type, copy, cooldownType, animState);
        this.entries.put((Object)type, entry);
        return entry;
    }

    private void register(MoveMap.Entry<A, S> entry) {
        this.checkFrozen();
        this.entries.put((Object)entry.getMoveClass(), entry.copy());
    }

    @Override
    public void freeze() {
        this.checkFrozen();
        this.frozen = true;
        this.allMoves = this.toList();
    }

    @Override
    public void copyFrom(@NotNull MoveMap<A, S> other, boolean force) {
        if (!force) {
            this.checkFrozen();
        }
        this.entries.clear();
        other.getEntries().values().forEach(this::register);
    }

    @Override
    @NonNull
    public Collection<MoveMap.Entry<A, S>> getEntries(@NotNull MoveClass type) {
        return Collections.unmodifiableList(this.entries.get((Object)type));
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("MoveMap is already frozen.");
        }
    }

    @Override
    @NonNull
    public Iterator<MoveMap.Entry<A, S>> iterator() {
        return this.entries.values().stream().flatMap(this::streamEntryAndChildren).iterator();
    }

    private List<AbstractMove<?, ? super A>> toList() {
        return (List)ImmutableList.copyOf((Iterable)this).stream().map(MoveMap.Entry::getMove).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<AbstractMove<?, ? super A>> asMovesList() {
        return this.frozen && this.allMoves != null ? this.allMoves : this.toList();
    }

    private Stream<MoveMap.Entry<A, S>> streamEntryAndChildren(MoveMap.Entry<A, S> entry) {
        Stream.Builder<MoveMap.Entry<A, S>> builder = Stream.builder();
        builder.add(entry);
        if (entry.getCrouchingVariant() != null) {
            this.streamEntryAndChildren(entry.getCrouchingVariant()).forEach(builder::add);
        }
        if (entry.getAerialVariant() != null) {
            this.streamEntryAndChildren(entry.getAerialVariant()).forEach(builder::add);
        }
        if (entry.getFollowup() != null) {
            this.streamEntryAndChildren(entry.getFollowup()).forEach(builder::add);
        }
        return builder.build();
    }

    @Override
    public Multimap<MoveClass, MoveMap.Entry<A, S>> getEntries() {
        return ImmutableListMultimap.copyOf(this.entries);
    }

    public MoveMapImpl() {
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    public static class EntryImpl<A extends IAttacker<? extends A, S>, S extends Enum<?>>
    implements MoveMap.Entry<A, S> {
        private final MoveClass moveClass;
        private final AbstractMove<?, ? super A> move;
        private final CooldownType cooldownType;
        @Nullable
        private final S animState;
        @Nullable
        private MoveMap.Entry<A, S> crouchingVariant;
        @Nullable
        private MoveMap.Entry<A, S> aerialVariant;
        @Nullable
        private MoveMap.Entry<A, S> followup;

        public EntryImpl(MoveClass moveClass, AbstractMove<?, ? super A> move, CooldownType cooldownType, @Nullable S animState) {
            this.moveClass = moveClass;
            this.move = move;
            this.cooldownType = cooldownType;
            this.animState = animState;
            if (move.getCrouchingVariant() != null) {
                this.crouchingVariant = new EntryImpl<A, S>(moveClass, move.getCrouchingVariant(), cooldownType, animState);
            }
            if (move.getAerialVariant() != null) {
                this.aerialVariant = new EntryImpl<A, S>(moveClass, move.getAerialVariant(), cooldownType, animState);
            }
            if (move.getFollowup() != null) {
                this.followup = new EntryImpl<A, S>(moveClass, move.getFollowup(), cooldownType, animState);
            }
        }

        public EntryImpl(@NonNull MoveClass moveClass, @NonNull AbstractMove<?, ?> move, @NonNull CooldownType cooldownType, @Nullable S animState, @Nullable MoveMap.Entry<A, S> crouchingVariant, @Nullable MoveMap.Entry<A, S> aerialVariant, @Nullable MoveMap.Entry<A, S> followup) {
            if (moveClass == null) {
                throw new NullPointerException("moveClass is marked non-null but is null");
            }
            if (move == null) {
                throw new NullPointerException("move is marked non-null but is null");
            }
            if (cooldownType == null) {
                throw new NullPointerException("cooldownType is marked non-null but is null");
            }
            this.moveClass = moveClass;
            this.move = move;
            this.move.withAnim((Enum<?>)animState);
            this.cooldownType = cooldownType;
            this.animState = animState;
            this.crouchingVariant = crouchingVariant;
            this.aerialVariant = aerialVariant;
            this.followup = followup;
            if (this.crouchingVariant != null) {
                this.move.withCrouchingVariant((AbstractMove<?, A>)this.crouchingVariant.getMove().markCrouchingVariant());
            }
            if (this.aerialVariant != null) {
                this.move.withAerialVariant((AbstractMove<?, A>)this.aerialVariant.getMove().markAerialVariant());
            }
            if (this.followup != null) {
                this.move.withFollowup((AbstractMove<?, A>)this.followup.getMove().markFollowup());
            }
            this.move.onRegister(moveClass);
        }

        @Override
        public MoveMap.Entry<A, S> withCrouchingVariant(CooldownType cooldownType, S animState) {
            if (this.move.getCrouchingVariant() == null) {
                throw new IllegalArgumentException("The move of this entry has no crouching variant.");
            }
            this.crouchingVariant = new EntryImpl<A, S>(this.moveClass, this.move.getCrouchingVariant(), cooldownType, animState);
            return this.crouchingVariant;
        }

        @Override
        public MoveMap.Entry<A, S> withAerialVariant(CooldownType cooldownType, S animState) {
            if (this.move.getAerialVariant() == null) {
                throw new IllegalArgumentException("The move of this entry has no aerial variant.");
            }
            this.aerialVariant = new EntryImpl<A, S>(this.moveClass, this.move.getAerialVariant(), cooldownType, animState);
            return this.aerialVariant;
        }

        @Override
        public MoveMap.Entry<A, S> withFollowup(CooldownType cooldownType, S animState) {
            if (this.move.getFollowup() == null) {
                throw new IllegalArgumentException("The move of this entry has no follow-up.");
            }
            this.followup = new EntryImpl<A, S>(this.moveClass, this.move.getFollowup(), cooldownType, animState);
            return this.followup;
        }

        @Override
        public EntryImpl<A, S> copy() {
            return new EntryImpl<A, S>(this.moveClass, (AbstractMove<?, ?>)this.move.copy(), this.cooldownType, this.animState, this.crouchingVariant != null ? this.crouchingVariant.copy() : null, this.aerialVariant != null ? this.aerialVariant.copy() : null, this.followup != null ? this.followup.copy() : null);
        }

        public String toString() {
            return "Type: " + String.valueOf((Object)this.moveClass) + ", Move name: " + String.valueOf(this.move.getName()) + ", Move desc: " + String.valueOf(this.move.getDescription());
        }

        @Override
        public MoveClass getMoveClass() {
            return this.moveClass;
        }

        @Override
        public AbstractMove<?, ? super A> getMove() {
            return this.move;
        }

        @Override
        public CooldownType getCooldownType() {
            return this.cooldownType;
        }

        @Override
        @Nullable
        public S getAnimState() {
            return this.animState;
        }

        @Override
        @Nullable
        public MoveMap.Entry<A, S> getCrouchingVariant() {
            return this.crouchingVariant;
        }

        @Override
        @Nullable
        public MoveMap.Entry<A, S> getAerialVariant() {
            return this.aerialVariant;
        }

        @Override
        @Nullable
        public MoveMap.Entry<A, S> getFollowup() {
            return this.followup;
        }

        public void setCrouchingVariant(@Nullable MoveMap.Entry<A, S> crouchingVariant) {
            this.crouchingVariant = crouchingVariant;
        }

        public void setAerialVariant(@Nullable MoveMap.Entry<A, S> aerialVariant) {
            this.aerialVariant = aerialVariant;
        }

        public void setFollowup(@Nullable MoveMap.Entry<A, S> followup) {
            this.followup = followup;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntryImpl)) {
                return false;
            }
            EntryImpl other = (EntryImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MoveClass this$moveClass = this.getMoveClass();
            MoveClass other$moveClass = other.getMoveClass();
            if (this$moveClass == null ? other$moveClass != null : !((Object)((Object)this$moveClass)).equals((Object)other$moveClass)) {
                return false;
            }
            AbstractMove<?, A> this$move = this.getMove();
            AbstractMove<?, A> other$move = other.getMove();
            if (this$move == null ? other$move != null : !this$move.equals(other$move)) {
                return false;
            }
            CooldownType this$cooldownType = this.getCooldownType();
            CooldownType other$cooldownType = other.getCooldownType();
            if (this$cooldownType == null ? other$cooldownType != null : !((Object)((Object)this$cooldownType)).equals((Object)other$cooldownType)) {
                return false;
            }
            S this$animState = this.getAnimState();
            S other$animState = other.getAnimState();
            if (this$animState == null ? other$animState != null : !this$animState.equals(other$animState)) {
                return false;
            }
            MoveMap.Entry<A, S> this$crouchingVariant = this.getCrouchingVariant();
            MoveMap.Entry<A, S> other$crouchingVariant = other.getCrouchingVariant();
            if (this$crouchingVariant == null ? other$crouchingVariant != null : !this$crouchingVariant.equals(other$crouchingVariant)) {
                return false;
            }
            MoveMap.Entry<A, S> this$aerialVariant = this.getAerialVariant();
            MoveMap.Entry<A, S> other$aerialVariant = other.getAerialVariant();
            if (this$aerialVariant == null ? other$aerialVariant != null : !this$aerialVariant.equals(other$aerialVariant)) {
                return false;
            }
            MoveMap.Entry<A, S> this$followup = this.getFollowup();
            MoveMap.Entry<A, S> other$followup = other.getFollowup();
            return !(this$followup == null ? other$followup != null : !this$followup.equals(other$followup));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntryImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MoveClass $moveClass = this.getMoveClass();
            result = result * 59 + ($moveClass == null ? 43 : ((Object)((Object)$moveClass)).hashCode());
            AbstractMove<?, A> $move = this.getMove();
            result = result * 59 + ($move == null ? 43 : $move.hashCode());
            CooldownType $cooldownType = this.getCooldownType();
            result = result * 59 + ($cooldownType == null ? 43 : ((Object)((Object)$cooldownType)).hashCode());
            S $animState = this.getAnimState();
            result = result * 59 + ($animState == null ? 43 : $animState.hashCode());
            MoveMap.Entry<A, S> $crouchingVariant = this.getCrouchingVariant();
            result = result * 59 + ($crouchingVariant == null ? 43 : $crouchingVariant.hashCode());
            MoveMap.Entry<A, S> $aerialVariant = this.getAerialVariant();
            result = result * 59 + ($aerialVariant == null ? 43 : $aerialVariant.hashCode());
            MoveMap.Entry<A, S> $followup = this.getFollowup();
            result = result * 59 + ($followup == null ? 43 : $followup.hashCode());
            return result;
        }
    }
}

