/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.core;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.IAttackerType;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.StateContainerHolder;
import net.arna.jcraft.common.attack.core.MoveMapImpl;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MoveSetImpl<A extends IAttacker<? extends A, S>, S extends Enum<S>>
implements MoveSet<A, S> {
    private final RegistrySupplier<? extends IAttackerType> type;
    private final String name;
    private final Consumer<MoveMap<A, S>> register;
    private final Class<S> stateClass;
    private final Codec<MoveMap<A, S>> codec;
    private final Codec<MoveMap.Entry<A, S>> entryCodec;
    private final Set<MoveSet.ReloadListener<A, S>> listeners = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final MoveMap<A, S> moveMap = new MoveMapImpl();
    private boolean initialized = false;

    public MoveSetImpl(@NonNull RegistrySupplier<? extends IAttackerType> type, @NonNull String name, @NonNull Consumer<MoveMap<A, S>> register, @NonNull Class<S> stateClass) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (register == null) {
            throw new NullPointerException("register is marked non-null but is null");
        }
        if (stateClass == null) {
            throw new NullPointerException("stateClass is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
        this.register = register;
        this.stateClass = stateClass;
        this.codec = MoveMap.codecFor(stateClass);
        this.entryCodec = MoveMap.Entry.codecFor(stateClass);
    }

    @Override
    public IAttackerType getType() {
        return (IAttackerType)this.type.get();
    }

    @Override
    public <T> DataResult<Pair<MoveMap<A, S>, T>> load(DynamicOps<T> ops, T t, Executor gameExecutor) {
        DataResult res = this.codec.decode(ops, t);
        if (res.result().isEmpty()) {
            return res;
        }
        this.onLoad((MoveMap)((Pair)res.result().get()).getFirst(), gameExecutor);
        return res;
    }

    @Override
    public <T> MoveMap<A, S> load(DynamicOps<? super T> ops, Collection<Pair<ResourceLocation, T>> ts, Executor gameExecutor) {
        List entries = ts.stream().map(p -> p.mapSecond(t -> this.entryCodec.decode(ops, t).map(Pair::getFirst))).map(p -> {
            Optional result = ((DataResult)p.getSecond()).result();
            if (result.isEmpty()) {
                JCraft.LOGGER.error("Failed to decode move set entry {}: {}", p.getFirst(), (Object)((DataResult)p.getSecond()).error().map(DataResult.PartialResult::message).orElse("Unknown error"));
                return null;
            }
            return (MoveMap.Entry)result.get();
        }).filter(Objects::nonNull).toList();
        MoveMapImpl moveMap = new MoveMapImpl(entries);
        this.onLoad(moveMap, gameExecutor);
        return moveMap;
    }

    private void onLoad(MoveMap<A, S> moveMap, @Nullable Executor gameExecutor) {
        moveMap.asMovesList().stream().filter(m -> m instanceof StateContainerHolder).map(m -> (StateContainerHolder)((Object)m)).forEach(holder -> holder.configureStateContainers(this.stateClass));
        this.moveMap.copyFrom(moveMap);
        this.initialized = true;
        if (gameExecutor != null) {
            gameExecutor.execute(() -> this.listeners.forEach(listener -> listener.onMoveSetReload(this)));
        }
    }

    @Override
    public MoveMap<A, S> save() {
        MoveMapImpl moveMap = new MoveMapImpl();
        this.register.accept(moveMap);
        return moveMap;
    }

    @Override
    public <T> DataResult<T> write(DynamicOps<T> ops) {
        MoveMap<A, S> moveMap = this.save();
        return this.codec.encodeStart(ops, moveMap);
    }

    @Override
    public <T> DataResult<T> writeModified(DynamicOps<T> ops) {
        return this.codec.encodeStart(ops, this.moveMap);
    }

    @Override
    public void registerListener(MoveSet.ReloadListener<A, S> listener) {
        if (!this.listeners.add(listener)) {
            return;
        }
        if (this.initialized) {
            listener.onMoveSetReload(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<S> getStateClass() {
        return this.stateClass;
    }

    @Override
    public Codec<MoveMap<A, S>> getCodec() {
        return this.codec;
    }

    @Override
    public MoveMap<A, S> getMoveMap() {
        return this.moveMap;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

