/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.core.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.core.HitBoxData;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.common.util.JParticleType;

public class AttackMoveExtras {
    public static final Codec<AttackMoveExtras> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StunType.CODEC.optionalFieldOf("stun_type", (Object)StunType.BURSTABLE).forGetter(AttackMoveExtras::getStunType), (App)Codec.BOOL.optionalFieldOf("override_stun", (Object)false).forGetter(AttackMoveExtras::isOverrideStun), (App)Codec.BOOL.optionalFieldOf("lift", (Object)true).forGetter(AttackMoveExtras::isLift), (App)Codec.BOOL.optionalFieldOf("backstab", (Object)false).forGetter(AttackMoveExtras::isBackstab), (App)Codec.INT.optionalFieldOf("block_stun", (Object)-1).forGetter(AttackMoveExtras::getBlockStun), (App)Codec.BOOL.optionalFieldOf("static_height", (Object)false).forGetter(AttackMoveExtras::isStaticHeight), (App)Codec.BOOL.optionalFieldOf("shockwaves", (Object)false).forGetter(AttackMoveExtras::isShockwaves), (App)BlockableType.CODEC.optionalFieldOf("blockable_type", (Object)BlockableType.BLOCKABLE).forGetter(AttackMoveExtras::getBlockableType), (App)CommonHitPropertyComponent.HitAnimation.CODEC.optionalFieldOf("hit_animation").forGetter(AttackMoveExtras::getHitAnimation), (App)JParticleType.CODEC.optionalFieldOf("hit_spark").forGetter(AttackMoveExtras::getHitSpark), (App)HitBoxData.CODEC.listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("extra_hit_boxes", new HashSet()).forGetter(AttackMoveExtras::getExtraHitBoxes)).apply((Applicative)instance, AttackMoveExtras::new));
    private StunType stunType = StunType.BURSTABLE;
    private boolean overrideStun = false;
    private boolean lift = true;
    private boolean backstab = false;
    private int blockStun = -1;
    private boolean staticHeight = false;
    private boolean shockwaves = false;
    @NonNull
    private BlockableType blockableType = BlockableType.BLOCKABLE;
    private Optional<CommonHitPropertyComponent.HitAnimation> hitAnimation = Optional.of(CommonHitPropertyComponent.HitAnimation.MID);
    private Optional<JParticleType> hitSpark = Optional.of(JParticleType.HIT_SPARK_1);
    private Set<HitBoxData> extraHitBoxes = new HashSet<HitBoxData>();

    public static AttackMoveExtras fromMove(AbstractSimpleAttack<?, ?> move) {
        return new AttackMoveExtras(move.getStunType(), move.isOverrideStun(), move.isLift(), move.isCanBackstab(), move.getBlockStun(), move.isStaticY(), move.isDoShockwaves(), move.getBlockableType(), Optional.ofNullable(move.getHitAnimation()), Optional.ofNullable(move.getHitSpark()), new HashSet<HitBoxData>(move.getExtraHitBoxes()));
    }

    public <M extends AbstractSimpleAttack<? extends M, ?>> M apply(M move) {
        ((AbstractSimpleAttack)((AbstractSimpleAttack)((AbstractSimpleAttack)((AbstractSimpleAttack)((AbstractSimpleAttack)((AbstractSimpleAttack)((AbstractSimpleAttack)((AbstractSimpleAttack)move.withStunType(this.stunType)).withOverrideStun(this.overrideStun)).withLift(this.lift)).withBackstab(this.backstab)).withBlockStun(this.blockStun)).withBlockableType(this.blockableType)).withHitAnimation(this.hitAnimation.orElse(null))).withHitSpark(this.hitSpark.orElse(null))).withShockwaves(this.shockwaves);
        this.extraHitBoxes.forEach(move::withExtraHitBox);
        return move;
    }

    public AttackMoveExtras withStunType(StunType stunType) {
        return this.stunType == stunType ? this : new AttackMoveExtras(stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withOverrideStun(boolean overrideStun) {
        return this.overrideStun == overrideStun ? this : new AttackMoveExtras(this.stunType, overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withLift(boolean lift) {
        return this.lift == lift ? this : new AttackMoveExtras(this.stunType, this.overrideStun, lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withBackstab(boolean backstab) {
        return this.backstab == backstab ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withBlockStun(int blockStun) {
        return this.blockStun == blockStun ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withStaticHeight(boolean staticHeight) {
        return this.staticHeight == staticHeight ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withShockwaves(boolean shockwaves) {
        return this.shockwaves == shockwaves ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withBlockableType(@NonNull BlockableType blockableType) {
        if (blockableType == null) {
            throw new NullPointerException("blockableType is marked non-null but is null");
        }
        return this.blockableType == blockableType ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, blockableType, this.hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withHitAnimation(Optional<CommonHitPropertyComponent.HitAnimation> hitAnimation) {
        return this.hitAnimation == hitAnimation ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, hitAnimation, this.hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withHitSpark(Optional<JParticleType> hitSpark) {
        return this.hitSpark == hitSpark ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, hitSpark, this.extraHitBoxes);
    }

    public AttackMoveExtras withExtraHitBoxes(Set<HitBoxData> extraHitBoxes) {
        return this.extraHitBoxes == extraHitBoxes ? this : new AttackMoveExtras(this.stunType, this.overrideStun, this.lift, this.backstab, this.blockStun, this.staticHeight, this.shockwaves, this.blockableType, this.hitAnimation, this.hitSpark, extraHitBoxes);
    }

    public StunType getStunType() {
        return this.stunType;
    }

    public boolean isOverrideStun() {
        return this.overrideStun;
    }

    public boolean isLift() {
        return this.lift;
    }

    public boolean isBackstab() {
        return this.backstab;
    }

    public int getBlockStun() {
        return this.blockStun;
    }

    public boolean isStaticHeight() {
        return this.staticHeight;
    }

    public boolean isShockwaves() {
        return this.shockwaves;
    }

    @NonNull
    public BlockableType getBlockableType() {
        return this.blockableType;
    }

    public Optional<CommonHitPropertyComponent.HitAnimation> getHitAnimation() {
        return this.hitAnimation;
    }

    public Optional<JParticleType> getHitSpark() {
        return this.hitSpark;
    }

    public Set<HitBoxData> getExtraHitBoxes() {
        return this.extraHitBoxes;
    }

    public void setStunType(StunType stunType) {
        this.stunType = stunType;
    }

    public void setOverrideStun(boolean overrideStun) {
        this.overrideStun = overrideStun;
    }

    public void setLift(boolean lift) {
        this.lift = lift;
    }

    public void setBackstab(boolean backstab) {
        this.backstab = backstab;
    }

    public void setBlockStun(int blockStun) {
        this.blockStun = blockStun;
    }

    public void setStaticHeight(boolean staticHeight) {
        this.staticHeight = staticHeight;
    }

    public void setShockwaves(boolean shockwaves) {
        this.shockwaves = shockwaves;
    }

    public void setBlockableType(@NonNull BlockableType blockableType) {
        if (blockableType == null) {
            throw new NullPointerException("blockableType is marked non-null but is null");
        }
        this.blockableType = blockableType;
    }

    public void setHitAnimation(Optional<CommonHitPropertyComponent.HitAnimation> hitAnimation) {
        this.hitAnimation = hitAnimation;
    }

    public void setHitSpark(Optional<JParticleType> hitSpark) {
        this.hitSpark = hitSpark;
    }

    public void setExtraHitBoxes(Set<HitBoxData> extraHitBoxes) {
        this.extraHitBoxes = extraHitBoxes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttackMoveExtras)) {
            return false;
        }
        AttackMoveExtras other = (AttackMoveExtras)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOverrideStun() != other.isOverrideStun()) {
            return false;
        }
        if (this.isLift() != other.isLift()) {
            return false;
        }
        if (this.isBackstab() != other.isBackstab()) {
            return false;
        }
        if (this.getBlockStun() != other.getBlockStun()) {
            return false;
        }
        if (this.isStaticHeight() != other.isStaticHeight()) {
            return false;
        }
        if (this.isShockwaves() != other.isShockwaves()) {
            return false;
        }
        StunType this$stunType = this.getStunType();
        StunType other$stunType = other.getStunType();
        if (this$stunType == null ? other$stunType != null : !((Object)((Object)this$stunType)).equals((Object)other$stunType)) {
            return false;
        }
        BlockableType this$blockableType = this.getBlockableType();
        BlockableType other$blockableType = other.getBlockableType();
        if (this$blockableType == null ? other$blockableType != null : !((Object)((Object)this$blockableType)).equals((Object)other$blockableType)) {
            return false;
        }
        Optional<CommonHitPropertyComponent.HitAnimation> this$hitAnimation = this.getHitAnimation();
        Optional<CommonHitPropertyComponent.HitAnimation> other$hitAnimation = other.getHitAnimation();
        if (this$hitAnimation == null ? other$hitAnimation != null : !((Object)this$hitAnimation).equals(other$hitAnimation)) {
            return false;
        }
        Optional<JParticleType> this$hitSpark = this.getHitSpark();
        Optional<JParticleType> other$hitSpark = other.getHitSpark();
        if (this$hitSpark == null ? other$hitSpark != null : !((Object)this$hitSpark).equals(other$hitSpark)) {
            return false;
        }
        Set<HitBoxData> this$extraHitBoxes = this.getExtraHitBoxes();
        Set<HitBoxData> other$extraHitBoxes = other.getExtraHitBoxes();
        return !(this$extraHitBoxes == null ? other$extraHitBoxes != null : !((Object)this$extraHitBoxes).equals(other$extraHitBoxes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttackMoveExtras;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOverrideStun() ? 79 : 97);
        result = result * 59 + (this.isLift() ? 79 : 97);
        result = result * 59 + (this.isBackstab() ? 79 : 97);
        result = result * 59 + this.getBlockStun();
        result = result * 59 + (this.isStaticHeight() ? 79 : 97);
        result = result * 59 + (this.isShockwaves() ? 79 : 97);
        StunType $stunType = this.getStunType();
        result = result * 59 + ($stunType == null ? 43 : ((Object)((Object)$stunType)).hashCode());
        BlockableType $blockableType = this.getBlockableType();
        result = result * 59 + ($blockableType == null ? 43 : ((Object)((Object)$blockableType)).hashCode());
        Optional<CommonHitPropertyComponent.HitAnimation> $hitAnimation = this.getHitAnimation();
        result = result * 59 + ($hitAnimation == null ? 43 : ((Object)$hitAnimation).hashCode());
        Optional<JParticleType> $hitSpark = this.getHitSpark();
        result = result * 59 + ($hitSpark == null ? 43 : ((Object)$hitSpark).hashCode());
        Set<HitBoxData> $extraHitBoxes = this.getExtraHitBoxes();
        result = result * 59 + ($extraHitBoxes == null ? 43 : ((Object)$extraHitBoxes).hashCode());
        return result;
    }

    public String toString() {
        return "AttackMoveExtras(stunType=" + String.valueOf((Object)this.getStunType()) + ", overrideStun=" + this.isOverrideStun() + ", lift=" + this.isLift() + ", backstab=" + this.isBackstab() + ", blockStun=" + this.getBlockStun() + ", staticHeight=" + this.isStaticHeight() + ", shockwaves=" + this.isShockwaves() + ", blockableType=" + String.valueOf((Object)this.getBlockableType()) + ", hitAnimation=" + String.valueOf(this.getHitAnimation()) + ", hitSpark=" + String.valueOf(this.getHitSpark()) + ", extraHitBoxes=" + String.valueOf(this.getExtraHitBoxes()) + ")";
    }

    public AttackMoveExtras(StunType stunType, boolean overrideStun, boolean lift, boolean backstab, int blockStun, boolean staticHeight, boolean shockwaves, @NonNull BlockableType blockableType, Optional<CommonHitPropertyComponent.HitAnimation> hitAnimation, Optional<JParticleType> hitSpark, Set<HitBoxData> extraHitBoxes) {
        if (blockableType == null) {
            throw new NullPointerException("blockableType is marked non-null but is null");
        }
        this.stunType = stunType;
        this.overrideStun = overrideStun;
        this.lift = lift;
        this.backstab = backstab;
        this.blockStun = blockStun;
        this.staticHeight = staticHeight;
        this.shockwaves = shockwaves;
        this.blockableType = blockableType;
        this.hitAnimation = hitAnimation;
        this.hitSpark = hitSpark;
        this.extraHitBoxes = extraHitBoxes;
    }

    public AttackMoveExtras() {
    }
}

