/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.core.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.core.MoveAction;
import net.arna.jcraft.api.attack.core.MoveCondition;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;

public class BaseMoveExtras {
    public static final Supplier<Codec<BaseMoveExtras>> CODEC = () -> RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.optionalFieldOf("name", (Object)Component.m_237119_()).forGetter(BaseMoveExtras::getName), (App)ExtraCodecs.f_252442_.optionalFieldOf("description", (Object)Component.m_237119_()).forGetter(BaseMoveExtras::getDescription), (App)JRegistries.MOVE_CONDITION_CODEC.listOf().optionalFieldOf("conditions", new ArrayList()).forGetter(BaseMoveExtras::getConditions), (App)JRegistries.MOVE_ACTION_CODEC.listOf().optionalFieldOf("actions", new ArrayList()).forGetter(BaseMoveExtras::getActions), (App)ExtraCodecs.f_144628_.optionalFieldOf("armor", (Object)0).forGetter(BaseMoveExtras::getArmor), (App)MobilityType.CODEC.optionalFieldOf("mobility_type").forGetter(BaseMoveExtras::getMobilityType), (App)Codec.BOOL.optionalFieldOf("is_holdable").forGetter(BaseMoveExtras::getIsHoldable), (App)Codec.BOOL.optionalFieldOf("ranged", (Object)false).forGetter(BaseMoveExtras::isRanged), (App)Codec.BOOL.optionalFieldOf("may_hit_user", (Object)false).forGetter(BaseMoveExtras::isMayHitUser), (App)RecordCodecBuilder.create(i1 -> i1.group((App)Codec.INT.fieldOf("tick").forGetter(IntObjectPair::leftInt), (App)JRegistries.MOVE_CODEC.fieldOf("move").forGetter(Pair::right)).apply((Applicative)i1, IntObjectPair::of)).optionalFieldOf("finisher").forGetter(BaseMoveExtras::getFinisher), (App)ExtraCodecs.f_144629_.optionalFieldOf("followup_frame").xmap(i -> i.map(OptionalInt::of).orElseGet(OptionalInt::empty), i -> i.isEmpty() ? Optional.empty() : Optional.of(i.getAsInt())).forGetter(BaseMoveExtras::getFollowupFrame), (App)Codec.BOOL.optionalFieldOf("loop_prevention", (Object)true).forGetter(BaseMoveExtras::isLoopPrevention)).apply((Applicative)instance, BaseMoveExtras::new));
    private Component name = Component.m_237119_();
    private Component description = Component.m_237119_();
    private final List<MoveCondition<?, ?>> conditions = new ArrayList();
    private final List<MoveAction<?, ?>> actions = new ArrayList();
    private final List<MoveAction<?, ?>> initActions = new ArrayList();
    private int armor;
    protected Optional<MobilityType> mobilityType = Optional.empty();
    private Optional<Boolean> isHoldable = Optional.empty();
    protected boolean ranged;
    protected boolean mayHitUser;
    private Optional<IntObjectPair<AbstractMove<?, ?>>> finisher = Optional.empty();
    private OptionalInt followupFrame = OptionalInt.empty();
    private boolean loopPrevention = true;

    private BaseMoveExtras(Component name, Component description, List<MoveCondition<?, ?>> conditions, List<MoveAction<?, ?>> actions, int armor, Optional<MobilityType> mobilityType, Optional<Boolean> isHoldable, boolean ranged, boolean mayHitUser, Optional<IntObjectPair<AbstractMove<?, ?>>> finisher, OptionalInt followupFrame, boolean loopPrevention) {
        this.name = name;
        this.description = description;
        this.conditions.addAll(conditions);
        this.actions.addAll(actions);
        this.armor = armor;
        this.mobilityType = mobilityType;
        this.isHoldable = isHoldable;
        this.ranged = ranged;
        this.mayHitUser = mayHitUser;
        this.finisher = finisher;
        this.followupFrame = followupFrame;
        this.loopPrevention = loopPrevention;
    }

    public static <A extends IAttacker<? extends A, ?>> BaseMoveExtras fromMove(AbstractMove<?, A> move) {
        return new BaseMoveExtras(move.getName(), move.getDescription(), move.getConditions(), move.getActions(), move.getArmor(), Optional.ofNullable(move.getMobilityType()), Optional.ofNullable(move.getIsHoldable()), move.isRanged(), move.isMayHitUser(), Optional.ofNullable(move.getFinisher()), move.getFollowupFrame(), move.isLoopPrevention());
    }

    public <M extends AbstractMove<? extends M, ?>> M apply(M move) {
        ((AbstractMove)((AbstractMove)((AbstractMove)((AbstractMove)((AbstractMove)((AbstractMove)((AbstractMove)move.withInfo(this.name, this.description)).withArmor(this.armor)).withMobilityType(this.mobilityType.orElse(null))).withHoldable(this.isHoldable.orElse(null))).withConditionsRaw(this.conditions)).withActionsRaw(this.actions)).withInitActionsRaw(this.initActions)).withFollowupFrame(this.followupFrame);
        if (this.ranged) {
            move.markRanged();
        }
        if (this.mayHitUser) {
            move.allowHitUser();
        }
        if (!this.loopPrevention) {
            move.noLoopPrevention();
        }
        this.finisher.ifPresent(f -> move.withFinisher(f.leftInt(), (AbstractMove)f.right()));
        return move;
    }

    public Component getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    public List<MoveCondition<?, ?>> getConditions() {
        return this.conditions;
    }

    public List<MoveAction<?, ?>> getActions() {
        return this.actions;
    }

    public List<MoveAction<?, ?>> getInitActions() {
        return this.initActions;
    }

    public int getArmor() {
        return this.armor;
    }

    public Optional<MobilityType> getMobilityType() {
        return this.mobilityType;
    }

    public Optional<Boolean> getIsHoldable() {
        return this.isHoldable;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public boolean isMayHitUser() {
        return this.mayHitUser;
    }

    public Optional<IntObjectPair<AbstractMove<?, ?>>> getFinisher() {
        return this.finisher;
    }

    public OptionalInt getFollowupFrame() {
        return this.followupFrame;
    }

    public boolean isLoopPrevention() {
        return this.loopPrevention;
    }

    public void setName(Component name) {
        this.name = name;
    }

    public void setDescription(Component description) {
        this.description = description;
    }

    public void setArmor(int armor) {
        this.armor = armor;
    }

    public void setMobilityType(Optional<MobilityType> mobilityType) {
        this.mobilityType = mobilityType;
    }

    public void setIsHoldable(Optional<Boolean> isHoldable) {
        this.isHoldable = isHoldable;
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }

    public void setMayHitUser(boolean mayHitUser) {
        this.mayHitUser = mayHitUser;
    }

    public void setFinisher(Optional<IntObjectPair<AbstractMove<?, ?>>> finisher) {
        this.finisher = finisher;
    }

    public void setFollowupFrame(OptionalInt followupFrame) {
        this.followupFrame = followupFrame;
    }

    public void setLoopPrevention(boolean loopPrevention) {
        this.loopPrevention = loopPrevention;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMoveExtras)) {
            return false;
        }
        BaseMoveExtras other = (BaseMoveExtras)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getArmor() != other.getArmor()) {
            return false;
        }
        if (this.isRanged() != other.isRanged()) {
            return false;
        }
        if (this.isMayHitUser() != other.isMayHitUser()) {
            return false;
        }
        if (this.isLoopPrevention() != other.isLoopPrevention()) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Component this$description = this.getDescription();
        Component other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<MoveCondition<?, ?>> this$conditions = this.getConditions();
        List<MoveCondition<?, ?>> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<MoveAction<?, ?>> this$actions = this.getActions();
        List<MoveAction<?, ?>> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        List<MoveAction<?, ?>> this$initActions = this.getInitActions();
        List<MoveAction<?, ?>> other$initActions = other.getInitActions();
        if (this$initActions == null ? other$initActions != null : !((Object)this$initActions).equals(other$initActions)) {
            return false;
        }
        Optional<MobilityType> this$mobilityType = this.getMobilityType();
        Optional<MobilityType> other$mobilityType = other.getMobilityType();
        if (this$mobilityType == null ? other$mobilityType != null : !((Object)this$mobilityType).equals(other$mobilityType)) {
            return false;
        }
        Optional<Boolean> this$isHoldable = this.getIsHoldable();
        Optional<Boolean> other$isHoldable = other.getIsHoldable();
        if (this$isHoldable == null ? other$isHoldable != null : !((Object)this$isHoldable).equals(other$isHoldable)) {
            return false;
        }
        Optional<IntObjectPair<AbstractMove<?, ?>>> this$finisher = this.getFinisher();
        Optional<IntObjectPair<AbstractMove<?, ?>>> other$finisher = other.getFinisher();
        if (this$finisher == null ? other$finisher != null : !((Object)this$finisher).equals(other$finisher)) {
            return false;
        }
        OptionalInt this$followupFrame = this.getFollowupFrame();
        OptionalInt other$followupFrame = other.getFollowupFrame();
        return !(this$followupFrame == null ? other$followupFrame != null : !((Object)this$followupFrame).equals(other$followupFrame));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMoveExtras;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getArmor();
        result = result * 59 + (this.isRanged() ? 79 : 97);
        result = result * 59 + (this.isMayHitUser() ? 79 : 97);
        result = result * 59 + (this.isLoopPrevention() ? 79 : 97);
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Component $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<MoveCondition<?, ?>> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<MoveAction<?, ?>> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        List<MoveAction<?, ?>> $initActions = this.getInitActions();
        result = result * 59 + ($initActions == null ? 43 : ((Object)$initActions).hashCode());
        Optional<MobilityType> $mobilityType = this.getMobilityType();
        result = result * 59 + ($mobilityType == null ? 43 : ((Object)$mobilityType).hashCode());
        Optional<Boolean> $isHoldable = this.getIsHoldable();
        result = result * 59 + ($isHoldable == null ? 43 : ((Object)$isHoldable).hashCode());
        Optional<IntObjectPair<AbstractMove<?, ?>>> $finisher = this.getFinisher();
        result = result * 59 + ($finisher == null ? 43 : ((Object)$finisher).hashCode());
        OptionalInt $followupFrame = this.getFollowupFrame();
        result = result * 59 + ($followupFrame == null ? 43 : ((Object)$followupFrame).hashCode());
        return result;
    }

    public String toString() {
        return "BaseMoveExtras(name=" + String.valueOf(this.getName()) + ", description=" + String.valueOf(this.getDescription()) + ", conditions=" + String.valueOf(this.getConditions()) + ", actions=" + String.valueOf(this.getActions()) + ", initActions=" + String.valueOf(this.getInitActions()) + ", armor=" + this.getArmor() + ", mobilityType=" + String.valueOf(this.getMobilityType()) + ", isHoldable=" + String.valueOf(this.getIsHoldable()) + ", ranged=" + this.isRanged() + ", mayHitUser=" + this.isMayHitUser() + ", finisher=" + String.valueOf(this.getFinisher()) + ", followupFrame=" + String.valueOf(this.getFollowupFrame()) + ", loopPrevention=" + this.isLoopPrevention() + ")";
    }

    public BaseMoveExtras() {
    }
}

