/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.anubis;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractUppercutAttack;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class LowKickAttack
extends AbstractUppercutAttack<LowKickAttack, AnubisSpec> {
    public LowKickAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, float strength) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, strength);
    }

    @Override
    @NonNull
    public MoveType<LowKickAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AnubisSpec attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (!targets.isEmpty() && user instanceof Player) {
            attacker.setTicksSinceLastHit(0);
        }
        return targets;
    }

    @Override
    @NonNull
    protected LowKickAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LowKickAttack copy() {
        return this.copyExtras(new LowKickAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getStrength()));
    }

    public static class Type
    extends AbstractUppercutAttack.Type<LowKickAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<LowKickAttack>, LowKickAttack> buildCodec(RecordCodecBuilder.Instance<LowKickAttack> instance) {
            return this.uppercutDefault(instance, LowKickAttack::new);
        }
    }
}

