/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.anubis;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.minecraft.world.entity.LivingEntity;

public class Rekka3Attack
extends AbstractMultiHitAttack<Rekka3Attack, AnubisSpec> {
    public Rekka3Attack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public MoveType<Rekka3Attack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AnubisSpec attacker, LivingEntity user) {
        if (attacker.getAttackSpeedMult() == 1.0f && this.getBlow(attacker) == 1) {
            attacker.curMove = this.getFollowup();
        }
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.tryIncrementBloodlust(targets);
        return targets;
    }

    @Override
    @NonNull
    protected Rekka3Attack getThis() {
        return this;
    }

    @Override
    @NonNull
    public Rekka3Attack copy() {
        return this.copyExtras(new Rekka3Attack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments()));
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<Rekka3Attack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<Rekka3Attack>, Rekka3Attack> buildCodec(RecordCodecBuilder.Instance<Rekka3Attack> instance) {
            return this.multiHitDefault(instance, Rekka3Attack::new);
        }
    }
}

