/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.anubis;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.minecraft.world.entity.LivingEntity;

public class SimpleAnubisAttack
extends AbstractSimpleAttack<SimpleAnubisAttack, AnubisSpec> {
    private final boolean checkHoldingAnubis;
    private final boolean incrementBloodlust;

    public SimpleAnubisAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, boolean checkHoldingAnubis, boolean incrementBloodlust) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.checkHoldingAnubis = checkHoldingAnubis;
        this.incrementBloodlust = incrementBloodlust;
    }

    @Override
    @NonNull
    public MoveType<SimpleAnubisAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(AnubisSpec attacker) {
        return super.conditionsMet(attacker) && (!this.checkHoldingAnubis || attacker.isHoldingAnubis());
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AnubisSpec attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (this.incrementBloodlust) {
            attacker.tryIncrementBloodlust(targets);
        }
        return targets;
    }

    @Override
    @NonNull
    protected SimpleAnubisAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SimpleAnubisAttack copy() {
        return this.copyExtras(new SimpleAnubisAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.checkHoldingAnubis, this.incrementBloodlust));
    }

    public boolean isCheckHoldingAnubis() {
        return this.checkHoldingAnubis;
    }

    public boolean isIncrementBloodlust() {
        return this.incrementBloodlust;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<SimpleAnubisAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SimpleAnubisAttack>, SimpleAnubisAttack> buildCodec(RecordCodecBuilder.Instance<SimpleAnubisAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), (App)Codec.BOOL.fieldOf("check_holding_anubis").forGetter(SimpleAnubisAttack::isCheckHoldingAnubis), (App)Codec.BOOL.fieldOf("increment_bloodlust").forGetter(SimpleAnubisAttack::isIncrementBloodlust)).apply(instance, this.applyAttackExtras(SimpleAnubisAttack::new));
        }
    }
}

