/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.anubis;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class SimpleAnubisMultiHitAttack
extends AbstractMultiHitAttack<SimpleAnubisMultiHitAttack, AnubisSpec> {
    private final boolean unsheatheSweep;

    public SimpleAnubisMultiHitAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments, boolean unsheatheSweep) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
        this.unsheatheSweep = unsheatheSweep;
    }

    @Override
    @NonNull
    public MoveType<SimpleAnubisMultiHitAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(AnubisSpec attacker) {
        return super.conditionsMet(attacker) && this.unsheatheSweep ? attacker.isHoldingSheathedAnubis() : attacker.isHoldingAnubis();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AnubisSpec attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.tryIncrementBloodlust(targets);
        if (!this.unsheatheSweep || this.getBlow(attacker) != 1) {
            return targets;
        }
        attacker.unsheatheAttack(targets);
        targets.forEach(target -> {
            if (!JUtils.isBlocking(target)) {
                target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 35, 0));
            }
        });
        return targets;
    }

    @Override
    @NonNull
    protected SimpleAnubisMultiHitAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SimpleAnubisMultiHitAttack copy() {
        return this.copyExtras(new SimpleAnubisMultiHitAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments(), this.unsheatheSweep));
    }

    public boolean isUnsheatheSweep() {
        return this.unsheatheSweep;
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<SimpleAnubisMultiHitAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SimpleAnubisMultiHitAttack>, SimpleAnubisMultiHitAttack> buildCodec(RecordCodecBuilder.Instance<SimpleAnubisMultiHitAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMoments(), (App)Codec.BOOL.fieldOf("unsheathe_sweep").forGetter(SimpleAnubisMultiHitAttack::isUnsheatheSweep)).apply(instance, this.applyAttackExtras(SimpleAnubisMultiHitAttack::new));
        }
    }
}

