/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.anubis;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.minecraft.world.entity.LivingEntity;

public class UnsheathingAttack
extends AbstractSimpleAttack<UnsheathingAttack, AnubisSpec> {
    public UnsheathingAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<UnsheathingAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(AnubisSpec attacker) {
        return super.conditionsMet(attacker) && attacker.isHoldingSheathedAnubis();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AnubisSpec attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.tryIncrementBloodlust(targets);
        attacker.unsheatheAttack(targets);
        return targets;
    }

    @Override
    @NonNull
    protected UnsheathingAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public UnsheathingAttack copy() {
        return this.copyExtras(new UnsheathingAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<UnsheathingAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<UnsheathingAttack>, UnsheathingAttack> buildCodec(RecordCodecBuilder.Instance<UnsheathingAttack> instance) {
            return this.attackDefault(instance, UnsheathingAttack::new);
        }
    }
}

