/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cmoon;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class CGroundSlamAttack
extends AbstractSimpleAttack<CGroundSlamAttack, CMoonEntity> {
    public CGroundSlamAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    protected void processTarget(CMoonEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        LivingEntity user = attacker.getUserOrThrow();
        GravityChangerAPI.setWorldVelocity((Entity)target, GravityChangerAPI.getGravityDirection((Entity)user).m_253071_());
        target.f_19864_ = true;
        if (user.m_6144_()) {
            target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 30, 0, true, false));
        }
    }

    @Override
    public void performHook(CMoonEntity attacker, Set<LivingEntity> targets, Set<AABB> boxes, DamageSource damageSource, Vec3 forwardPos, Vec3 rotationVector) {
        Level world = attacker.m_9236_();
        Vec3i gravityVector = GravityChangerAPI.getGravityDirection((Entity)attacker).m_122436_();
        if (world.m_46469_().m_46207_(JCraft.STAND_GRIEFING)) {
            BlockPos bPos = attacker.m_20183_();
            Vec3i min = new Vec3i(-2, -2, -2);
            Vec3i max = new Vec3i(3, 3, 3);
            min = min.m_121996_(gravityVector);
            max = max.m_121955_(gravityVector);
            for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
                for (int y = min.m_123342_(); y < max.m_123342_(); ++y) {
                    for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                        BlockPos curPos = bPos.m_7918_(x, y, z);
                        BlockState curState = world.m_8055_(curPos);
                        Block block = curState.m_60734_();
                        if (block.m_155943_() < 0.0f || block.m_7325_() > 10.0f || curState.m_60795_()) continue;
                        FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)world, (BlockPos)curPos, (BlockState)curState);
                        fallingBlock.m_20334_((double)(-gravityVector.m_123341_()) * 0.5, (double)(-gravityVector.m_123342_()) * 0.5, (double)(-gravityVector.m_123343_()) * 0.5);
                        fallingBlock.f_31942_ = -120;
                        fallingBlock.f_19864_ = true;
                        fallingBlock.f_19812_ = true;
                    }
                }
            }
        }
        JComponentPlatformUtils.getShockwaveHandler(attacker.m_9236_()).addShockwave(attacker.m_20182_().m_82549_(rotationVector), new Vec3(GravityChangerAPI.getGravityDirection((Entity)attacker).m_253071_()), 4.0f);
    }

    @Override
    @NotNull
    public MoveType<CGroundSlamAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected CGroundSlamAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CGroundSlamAttack copy() {
        return this.copyExtras(new CGroundSlamAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<CGroundSlamAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<CGroundSlamAttack>, CGroundSlamAttack> buildCodec(RecordCodecBuilder.Instance<CGroundSlamAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset()).apply(instance, this.applyAttackExtras(CGroundSlamAttack::new));
        }
    }
}

