/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cmoon;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class GravPunchAttack
extends AbstractSimpleAttack<GravPunchAttack, CMoonEntity> {
    public static final String GRAVITY_SOURCE = "jcraft$" + GravPunchAttack.class.getSimpleName();

    public GravPunchAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.INVERTED_HIT_SPARK_3;
    }

    @Override
    protected void processTarget(CMoonEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        Direction oppositeGravity = GravityChangerAPI.getGravityDirection((Entity)target).m_122424_();
        GravityChangerAPI.addGravity((Entity)target, new Gravity(oppositeGravity, 2, 60, GRAVITY_SOURCE));
        target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.WEIGHTLESS.get(), 60, 0, true, false));
        JUtils.setVelocity((Entity)target, (double)oppositeGravity.m_122429_() * 0.2, (double)oppositeGravity.m_122430_() * 0.2, (double)oppositeGravity.m_122431_() * 0.2);
    }

    @Override
    public void performHook(CMoonEntity attacker, Set<LivingEntity> targets, Set<AABB> boxes, DamageSource damageSource, Vec3 forwardPos, Vec3 rotationVector) {
        if (targets.isEmpty()) {
            JCraft.stun(attacker.getUserOrThrow(), 15, 0);
            return;
        }
        JComponentPlatformUtils.getShockwaveHandler(attacker.m_9236_()).addShockwave(forwardPos, new Vec3(GravityChangerAPI.getGravityDirection((Entity)attacker).m_253071_()), 3.0f);
    }

    @Override
    @NotNull
    public MoveType<GravPunchAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected GravPunchAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public GravPunchAttack copy() {
        return this.copyExtras(new GravPunchAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<GravPunchAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<GravPunchAttack>, GravPunchAttack> buildCodec(RecordCodecBuilder.Instance<GravPunchAttack> instance) {
            return this.attackDefault(instance, GravPunchAttack::new);
        }
    }
}

