/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cmoon;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class GravitationalHopMove
extends AbstractMove<GravitationalHopMove, CMoonEntity> {
    private final int weightlessDuration;
    private final int slowFallingDuration;

    public GravitationalHopMove(int cooldown, int weightlessDuration, int slowFallingDuration) {
        super(cooldown, 0, 0, 0.0f);
        this.weightlessDuration = weightlessDuration;
        this.slowFallingDuration = slowFallingDuration;
        this.mobilityType = MobilityType.HIGHJUMP;
    }

    @Override
    @NotNull
    public MoveType<GravitationalHopMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CMoonEntity attacker, LivingEntity user) {
        if (user.m_20096_()) {
            if (user.m_21023_((MobEffect)JStatusRegistry.WEIGHTLESS.get())) {
                user.m_21195_((MobEffect)JStatusRegistry.WEIGHTLESS.get());
            }
            user.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.WEIGHTLESS.get(), this.getWeightlessDuration(), 1));
        } else {
            user.m_7292_(new MobEffectInstance(MobEffects.f_19591_, this.getSlowFallingDuration(), 1));
            user.m_5997_(0.0, 1.0, 0.0);
        }
        user.f_19864_ = true;
        return Set.of();
    }

    @Override
    @NonNull
    protected GravitationalHopMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public GravitationalHopMove copy() {
        return this.copyExtras(new GravitationalHopMove(this.getCooldown(), this.getWeightlessDuration(), this.getSlowFallingDuration()));
    }

    public int getWeightlessDuration() {
        return this.weightlessDuration;
    }

    public int getSlowFallingDuration() {
        return this.slowFallingDuration;
    }

    public static class Type
    extends AbstractMove.Type<GravitationalHopMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<GravitationalHopMove>, GravitationalHopMove> buildCodec(RecordCodecBuilder.Instance<GravitationalHopMove> instance) {
            return instance.group(this.extras(), this.cooldown(), (App)ExtraCodecs.f_144628_.fieldOf("weightless_duration").forGetter(GravitationalHopMove::getWeightlessDuration), (App)ExtraCodecs.f_144628_.fieldOf("slow_falling_duration").forGetter(GravitationalHopMove::getSlowFallingDuration)).apply(instance, this.applyExtras(GravitationalHopMove::new));
        }
    }
}

