/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cmoon;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class GravityShiftMove
extends AbstractMove<GravityShiftMove, CMoonEntity> {
    public GravityShiftMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<GravityShiftMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CMoonEntity attacker, LivingEntity user) {
        JComponentPlatformUtils.getGravityShift(user).startRadial();
        return Set.of();
    }

    @Override
    @NonNull
    protected GravityShiftMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public GravityShiftMove copy() {
        return this.copyExtras(new GravityShiftMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<GravityShiftMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<GravityShiftMove>, GravityShiftMove> buildCodec(RecordCodecBuilder.Instance<GravityShiftMove> instance) {
            return this.baseDefault(instance, GravityShiftMove::new);
        }
    }
}

