/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cmoon;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class GravityShiftPulseMove
extends AbstractMove<GravityShiftPulseMove, CMoonEntity> {
    public GravityShiftPulseMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<GravityShiftPulseMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CMoonEntity attacker, LivingEntity user) {
        JComponentPlatformUtils.getGravityShift(user).startDirectional();
        return Set.of();
    }

    @Override
    @NonNull
    protected GravityShiftPulseMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public GravityShiftPulseMove copy() {
        return this.copyExtras(new GravityShiftPulseMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<GravityShiftPulseMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<GravityShiftPulseMove>, GravityShiftPulseMove> buildCodec(RecordCodecBuilder.Instance<GravityShiftPulseMove> instance) {
            return this.baseDefault(instance, GravityShiftPulseMove::new);
        }
    }
}

