/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cmoon;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.BlockProjectile;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class LaunchAttack
extends AbstractSimpleAttack<LaunchAttack, CMoonEntity> {
    public LaunchAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
        this.hitSpark = JParticleType.HIT_SPARK_2;
    }

    @Override
    @NotNull
    public MoveType<LaunchAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CMoonEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        BlockProjectile block = new BlockProjectile(attacker.m_9236_());
        BlockState steppingState = attacker.m_20075_();
        if (steppingState.m_60795_() || !steppingState.m_60815_()) {
            block.setBlockStack(Items.f_41905_.m_7968_());
        } else {
            block.setBlockStack(steppingState.m_60734_().m_5456_().m_7968_());
        }
        Vec3i hoverDir = GravityChangerAPI.getGravityDirection((Entity)user).m_122436_().m_142393_(-1);
        block.setMaster(user);
        block.m_7678_(attacker.m_20185_() + (double)hoverDir.m_123341_() * 1.5, attacker.m_20186_() + (double)hoverDir.m_123342_() * 1.5, attacker.m_20189_() + (double)hoverDir.m_123343_() * 1.5, attacker.m_146908_(), attacker.m_146909_());
        block.m_20334_((double)hoverDir.m_123341_() * 0.4, (double)hoverDir.m_123342_() * 0.4, (double)hoverDir.m_123343_() * 0.4);
        attacker.m_9236_().m_7967_((Entity)block);
        return targets;
    }

    @Override
    @NonNull
    protected LaunchAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LaunchAttack copy() {
        return this.copyExtras(new LaunchAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<LaunchAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<LaunchAttack>, LaunchAttack> buildCodec(RecordCodecBuilder.Instance<LaunchAttack> instance) {
            return this.attackDefault(instance, LaunchAttack::new);
        }
    }
}

