/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cream;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BallChargeAttack
extends AbstractMove<BallChargeAttack, CreamEntity> {
    private final boolean downward;

    public BallChargeAttack(int cooldown, int windup, int duration, float moveDistance, boolean downward) {
        super(cooldown, windup, duration, moveDistance);
        this.downward = downward;
    }

    @Override
    @NotNull
    public MoveType<BallChargeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CreamEntity attacker, LivingEntity user) {
        attacker.m_5496_((SoundEvent)JSoundRegistry.CREAM_CHARGE.get(), 1.0f, 1.0f);
        attacker.setCharging(true);
        attacker.setChargeDir(user.m_20154_().m_82490_(0.5));
        attacker.setVoidTime(15);
        return Set.of();
    }

    @Override
    public void activeTick(CreamEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        LivingEntity user = attacker.getUser();
        if (this.downward && !attacker.m_9236_().m_5776_() && attacker.getVoidTime() > 0 && user != null && attacker.isCharging() && attacker.getChargeDir() != null && !attacker.isFree()) {
            attacker.setChargeDir(attacker.getChargeDir().m_82549_(new Vec3(GravityChangerAPI.getGravityDirection((Entity)user).m_253071_()).m_82490_(0.1)).m_82541_().m_82490_(0.5));
        }
    }

    @Override
    @NonNull
    protected BallChargeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BallChargeAttack copy() {
        return this.copyExtras(new BallChargeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.isDownward()));
    }

    public boolean isDownward() {
        return this.downward;
    }

    public static class Type
    extends AbstractMove.Type<BallChargeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<BallChargeAttack>, BallChargeAttack> buildCodec(RecordCodecBuilder.Instance<BallChargeAttack> instance) {
            return this.baseDefault(instance).and((App)Codec.BOOL.fieldOf("downward").forGetter(BallChargeAttack::isDownward)).apply(instance, this.applyExtras(BallChargeAttack::new));
        }
    }
}

