/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cream;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class BallModeEnterMove
extends AbstractMove<BallModeEnterMove, CreamEntity> {
    public BallModeEnterMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.mobilityType = MobilityType.FLIGHT;
    }

    @Override
    @NonNull
    public MoveType<BallModeEnterMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CreamEntity attacker, LivingEntity user) {
        attacker.beginHalfBall();
        return Set.of();
    }

    @Override
    @NonNull
    protected BallModeEnterMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public BallModeEnterMove copy() {
        return this.copyExtras(new BallModeEnterMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<BallModeEnterMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<BallModeEnterMove>, BallModeEnterMove> buildCodec(RecordCodecBuilder.Instance<BallModeEnterMove> instance) {
            return this.baseDefault(instance, BallModeEnterMove::new);
        }
    }
}

