/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cream;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class ConsumeAttack
extends AbstractSimpleAttack<ConsumeAttack, CreamEntity> {
    public ConsumeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
    }

    @Override
    @NotNull
    public MoveType<ConsumeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CreamEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.setVoidTime(120);
        attacker.setCharging(false);
        attacker.setCurrentMove(null);
        return targets;
    }

    @Override
    @NonNull
    protected ConsumeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public ConsumeAttack copy() {
        return this.copyExtras(new ConsumeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<ConsumeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<ConsumeAttack>, ConsumeAttack> buildCodec(RecordCodecBuilder.Instance<ConsumeAttack> instance) {
            return this.attackDefault(instance, ConsumeAttack::new);
        }
    }
}

