/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cream;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class CreamComboAttack
extends AbstractMultiHitAttack<CreamComboAttack, CreamEntity> {
    public CreamComboAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
    }

    @Override
    @NotNull
    public MoveType<CreamComboAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CreamEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (this.getBlow(attacker) == 2) {
            Vec3 rV = CreamComboAttack.getRotVec(attacker);
            for (LivingEntity target : targets) {
                target.m_147240_(1.0, rV.f_82479_, rV.f_82481_);
                target.f_19864_ = true;
            }
        }
        return targets;
    }

    @Override
    @NonNull
    protected CreamComboAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CreamComboAttack copy() {
        return this.copyExtras(new CreamComboAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments()));
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<CreamComboAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<CreamComboAttack>, CreamComboAttack> buildCodec(RecordCodecBuilder.Instance<CreamComboAttack> instance) {
            return this.multiHitDefault(instance, CreamComboAttack::new);
        }
    }
}

