/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cream;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class DestroyAttack
extends AbstractSimpleAttack<DestroyAttack, CreamEntity> {
    private final int knockdownDuration;

    public DestroyAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int knockdownDuration) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.knockdownDuration = knockdownDuration;
        this.hitSpark = JParticleType.HIT_SPARK_3;
    }

    @Override
    protected void processTarget(CreamEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        Attacks.trueDamage(8.0f, JDamageSources.stand(attacker), target);
        target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), this.knockdownDuration, 0, true, false));
    }

    @Override
    @NotNull
    public MoveType<DestroyAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected DestroyAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public DestroyAttack copy() {
        return this.copyExtras(new DestroyAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.knockdownDuration));
    }

    public int getKnockdownDuration() {
        return this.knockdownDuration;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<DestroyAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<DestroyAttack>, DestroyAttack> buildCodec(RecordCodecBuilder.Instance<DestroyAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), (App)ExtraCodecs.f_144628_.fieldOf("knockdown_duration").forGetter(DestroyAttack::getKnockdownDuration)).apply(instance, this.applyAttackExtras(DestroyAttack::new));
        }
    }
}

