/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.cream;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.moves.cream.AbstractSurpriseMove;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SurpriseMove
extends AbstractSurpriseMove<SurpriseMove> {
    public SurpriseMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<SurpriseMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(CreamEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUser();
        if (user == null) {
            return;
        }
        Vec3 rotVec = user.m_20154_();
        if (user.m_6144_()) {
            this.outPos = user.m_20182_().m_82549_(rotVec).m_252839_();
        } else {
            Vec3 eyePos = user.m_146892_();
            BlockHitResult hitResult = attacker.m_9236_().m_45547_(new ClipContext(eyePos, eyePos.m_82549_(rotVec.m_82490_(16.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user));
            this.outPos = hitResult.m_82450_().m_252839_();
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(CreamEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        this.outDir = GravityChangerAPI.getGravityDirection((Entity)attacker).m_253071_();
        this.outDir.mul(-1.0f);
        return targets;
    }

    @Override
    @NonNull
    protected SurpriseMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public SurpriseMove copy() {
        return this.copyExtras(new SurpriseMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<SurpriseMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SurpriseMove>, SurpriseMove> buildCodec(RecordCodecBuilder.Instance<SurpriseMove> instance) {
            return this.baseDefault(instance, SurpriseMove::new);
        }
    }
}

