/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public final class CloneSpawnMove
extends AbstractMove<CloneSpawnMove, D4CEntity> {
    private CloneType cloneType = CloneType.SWORD;

    public CloneSpawnMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NotNull
    public MoveType<CloneSpawnMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(D4CEntity attacker) {
        super.onInitiate(attacker);
        this.cloneType = CloneType.SWORD;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(D4CEntity attacker, LivingEntity user) {
        ItemStack weapon = this.cloneType.weapon.m_7968_();
        if (weapon.m_41763_()) {
            weapon.m_41721_(weapon.m_41776_());
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)user;
            PlayerCloneEntity clone = new PlayerCloneEntity(attacker.m_9236_());
            clone.m_20359_((Entity)playerEntity);
            clone.setMaster((LivingEntity)playerEntity);
            clone.disableDrops();
            attacker.m_9236_().m_7967_((Entity)clone);
            clone.m_8061_(EquipmentSlot.MAINHAND, weapon);
            JComponentPlatformUtils.getStandComponent((LivingEntity)clone).setType((StandType)JStandTypeRegistry.NONE.get());
        } else if (user instanceof Mob) {
            Mob mob = (Mob)user;
            EntityType entityType = mob.m_6095_();
            Mob newMob = (Mob)entityType.m_20615_(attacker.m_9236_());
            if (newMob == null) {
                JCraft.LOGGER.error("Failed to create D4C clone mob of type {} in world {}", (Object)entityType, (Object)attacker.m_9236_());
                return Set.of();
            }
            newMob.m_20359_((Entity)mob);
            newMob.m_6863_(mob.m_6162_());
            if (mob.m_8077_()) {
                newMob.m_6593_(mob.m_7770_());
                newMob.m_20340_(mob.m_20151_());
            }
            newMob.f_19797_ = mob.f_19797_;
            attacker.m_9236_().m_7967_((Entity)newMob);
            newMob.m_8061_(EquipmentSlot.MAINHAND, weapon);
            JComponentPlatformUtils.getStandComponent((LivingEntity)newMob).setType((StandType)JStandTypeRegistry.NONE.get());
        }
        return Set.of();
    }

    @Override
    public boolean onInitMove(D4CEntity attacker, MoveClass moveClass) {
        switch (moveClass) {
            case SPECIAL1: {
                this.cloneType = CloneType.AXE;
                break;
            }
            case SPECIAL2: {
                this.cloneType = CloneType.BOW;
                break;
            }
            case SPECIAL3: {
                this.cloneType = CloneType.EMPTY;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    @NonNull
    protected CloneSpawnMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public CloneSpawnMove copy() {
        return this.copyExtras(new CloneSpawnMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static enum CloneType {
        SWORD(Items.f_42383_),
        AXE(Items.f_42423_),
        BOW(Items.f_42411_),
        EMPTY(Items.f_41852_);

        public final Item weapon;

        private CloneType(Item weapon) {
            this.weapon = weapon;
        }
    }

    public static class Type
    extends AbstractMove.Type<CloneSpawnMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<CloneSpawnMove>, CloneSpawnMove> buildCodec(RecordCodecBuilder.Instance<CloneSpawnMove> instance) {
            return this.baseDefault(instance, CloneSpawnMove::new);
        }
    }
}

