/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class D4CCounterAttack
extends AbstractCounterAttack<D4CCounterAttack, D4CEntity> {
    private final CounterMissMove<D4CEntity> counterMiss = new CounterMissMove(10);

    public D4CCounterAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<D4CCounterAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void whiff(@NonNull D4CEntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.setMove(this.counterMiss, D4CEntity.State.COUNTER_MISS);
        JCraft.stun(user, this.counterMiss.getDuration(), 0);
    }

    @Override
    public void counter(@NonNull D4CEntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        boolean bl = counteredDamageSource.m_276093_(DamageTypes.f_268534_);
        boolean bl2 = counteredDamageSource.m_276093_(DamageTypes.f_268515_);
        if (countered == null || !attacker.hasUser() || bl || bl2) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        Vec3 trueKnockback = countered.m_20182_().m_82546_(user.m_20182_()).m_82541_().m_82490_(1.5);
        countered.m_5997_(trueKnockback.f_82479_, 0.5, trueKnockback.f_82481_);
        countered.f_19864_ = true;
        if (countered instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)countered;
            livingEntity.m_6469_(livingEntity.m_9236_().m_269111_().m_269333_(user), 10.0f);
            JCraft.stun(livingEntity, 20, 3);
            JUtils.cancelMoves(livingEntity);
        }
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        attacker.m_5496_((SoundEvent)JSoundRegistry.D4C_COUNTER.get(), 1.0f, 1.0f);
    }

    @Override
    @NonNull
    protected D4CCounterAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public D4CCounterAttack copy() {
        return this.copyExtras(new D4CCounterAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<D4CCounterAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<D4CCounterAttack>, D4CCounterAttack> buildCodec(RecordCodecBuilder.Instance<D4CCounterAttack> instance) {
            return this.baseDefault(instance, D4CCounterAttack::new);
        }
    }
}

