/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JDimensionRegistry;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.arna.jcraft.common.tickable.PastDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;

public final class DimensionalHopMove
extends AbstractSimpleAttack<DimensionalHopMove, D4CEntity> {
    static final boolean enableLightingFix = false;

    public DimensionalHopMove(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NotNull
    public MoveType<DimensionalHopMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(D4CEntity attacker) {
        return super.conditionsMet(attacker) || attacker.m_9236_().m_46472_().equals(JDimensionRegistry.AU_DIMENSION_KEY);
    }

    @Override
    public void onInitiate(D4CEntity attacker) {
        super.onInitiate(attacker);
        if (attacker.m_9236_() != JCraft.auWorld) {
            JCraft.auWorld.m_7726_().m_8387_(TicketType.f_9447_, attacker.m_146902_(), -5, (Object)attacker.m_20183_());
            JCraft.preloadLockTicks = this.getWindup();
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(D4CEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        ServerLevel world = (ServerLevel)attacker.m_9236_();
        if (world.m_46472_().equals(JDimensionRegistry.AU_DIMENSION_KEY)) {
            if (!(user instanceof ServerPlayer)) {
                return Set.of();
            }
            ServerPlayer serverPlayer = (ServerPlayer)user;
            boolean isStored = PastDimensions.tryExit(user, targets);
            if (!isStored) {
                PastDimensions.safeReturn(serverPlayer);
            }
            return Set.of();
        }
        if (JCraft.auWorld == null) {
            throw new IllegalStateException("Alternate Universe could not be found.");
        }
        DimensionalHopMove.fixLightInAU(attacker, world, JCraft.auWorld);
        HashSet<LivingEntity> toHop = new HashSet<LivingEntity>(targets);
        toHop.add(user);
        int heightOffset = JCraft.auWorld.m_141928_() - world.m_141928_();
        for (LivingEntity entity : toHop) {
            JCraft.dimensionHop(entity, heightOffset / 2);
        }
        return targets;
    }

    private static void fixLightInAU(D4CEntity attacker, ServerLevel world, ServerLevel auWorld) {
        ChunkPos origin = attacker.m_146902_();
        boolean someModMessedUpLight = true;
        Object ogBlockLightStorage = null;
        Object ogUncachedBlockLightStorage = null;
        Object auBlockLightStorage = null;
        Object auUncachedBlockLightStorage = null;
        Object ogSkyLightStorage = null;
        Object ogUncachedSkyLightStorage = null;
        Object auSkyLightStorage = null;
        Object auUncachedSkyLightStorage = null;
        for (int x = -3; x < 4; ++x) {
            for (int z = -3; z < 4; ++z) {
                int cX = origin.f_45578_ + x;
                int cZ = origin.f_45579_ + z;
                JCraft.preloadChunk(auWorld, cX, cZ);
                LevelChunk ogChunk = world.m_6325_(cX, cZ);
                LevelChunk auChunk = auWorld.m_6325_(cX, cZ);
                LevelChunkSection[] sections = ogChunk.m_7103_();
                LevelChunkSection[] copies = (LevelChunkSection[])IntStream.range(0, sections.length).mapToObj(i -> {
                    LevelChunkSection copy = new LevelChunkSection(world.m_9598_().m_175515_(Registries.f_256952_));
                    FriendlyByteBuf serialized = new FriendlyByteBuf(Unpooled.buffer());
                    sections[i].m_63011_(serialized);
                    copy.m_63004_(serialized);
                    return copy;
                }).toArray(LevelChunkSection[]::new);
                LevelChunkSection[] auSec = auChunk.m_7103_();
                System.arraycopy(copies, 0, auSec, 0, Math.min(copies.length, auSec.length));
                if (someModMessedUpLight) continue;
                for (int y = auWorld.m_141937_(); y < auWorld.m_151558_(); y += 16) {
                    long cPos = SectionPos.m_175568_((BlockPos)new BlockPos(cX * 16, y, cZ * 16));
                    DataLayer a = ogBlockLightStorage.m_75532_(cPos);
                    if (a != null) {
                        auBlockLightStorage.m_75526_(cPos, a);
                    }
                    if ((a = ogUncachedBlockLightStorage.m_75532_(cPos)) != null) {
                        auUncachedBlockLightStorage.m_75526_(cPos, a);
                    }
                    if ((a = ogSkyLightStorage.m_75532_(cPos)) != null) {
                        auSkyLightStorage.m_75526_(cPos, a);
                    }
                    if ((a = ogUncachedSkyLightStorage.m_75532_(cPos)) == null) continue;
                    auUncachedSkyLightStorage.m_75526_(cPos, a);
                }
            }
        }
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(origin.m_45604_() - 48, world.m_141937_(), origin.m_45605_() - 48), (BlockPos)new BlockPos(origin.m_45608_() + 48, world.m_151558_(), origin.m_45609_() + 48))) {
            auWorld.m_46747_(pos);
            auWorld.m_7702_(pos);
        }
    }

    @Override
    @NonNull
    protected DimensionalHopMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public DimensionalHopMove copy() {
        return this.copyExtras(new DimensionalHopMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<DimensionalHopMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<DimensionalHopMove>, DimensionalHopMove> buildCodec(RecordCodecBuilder.Instance<DimensionalHopMove> instance) {
            return this.attackDefault(instance, DimensionalHopMove::new);
        }
    }
}

