/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public final class FlagMove
extends AbstractMove<FlagMove, D4CEntity> {
    public FlagMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.mobilityType = MobilityType.HIGHJUMP;
    }

    @Override
    @NonNull
    public MoveType<FlagMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(D4CEntity attacker) {
        super.onInitiate(attacker);
        attacker.getUserOrThrow().m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), this.getDuration(), 0, true, false));
        attacker.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19591_, this.getDuration(), 0, true, false));
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(D4CEntity attacker, LivingEntity user) {
        int duration = this.getWindupPoint();
        user.m_7292_(new MobEffectInstance(MobEffects.f_19609_, duration, 0, true, false));
        user.m_7292_(new MobEffectInstance(MobEffects.f_19620_, duration, 2, true, false));
        return Set.of();
    }

    @Override
    @NonNull
    protected FlagMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public FlagMove copy() {
        return this.copyExtras(new FlagMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<FlagMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FlagMove>, FlagMove> buildCodec(RecordCodecBuilder.Instance<FlagMove> instance) {
            return this.baseDefault(instance, FlagMove::new);
        }
    }
}

