/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.arna.jcraft.common.item.MockItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public final class ItemPlaceMove
extends AbstractMove<ItemPlaceMove, D4CEntity> {
    private static final List<ItemStack> placeableStacks = List.of(Items.f_42398_.m_7968_(), Items.f_42594_.m_7968_(), Items.f_41866_.m_7968_(), Items.f_42410_.m_7968_(), Items.f_42799_.m_7968_());
    private boolean placingFirstStack = true;
    private ItemStack placing;

    public ItemPlaceMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<ItemPlaceMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(D4CEntity attacker) {
        super.onInitiate(attacker);
        if (this.placingFirstStack) {
            this.placing = placeableStacks.get(attacker.m_217043_().m_188503_(placeableStacks.size()));
        }
        attacker.m_8061_(EquipmentSlot.OFFHAND, this.placing.m_41777_());
        this.placingFirstStack = !this.placingFirstStack;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(D4CEntity attacker, LivingEntity user) {
        ItemStack offHandStack = attacker.m_21206_();
        ItemEntity item = new ItemEntity(attacker.m_9236_(), attacker.m_20185_(), attacker.m_20186_() + 0.2, attacker.m_20189_(), MockItem.createMockStack(this.placing), 0.0, 0.0, 0.0);
        item.m_32010_(200);
        attacker.m_9236_().m_7967_((Entity)item);
        offHandStack.m_41774_(1);
        return Set.of();
    }

    @Override
    @NonNull
    protected ItemPlaceMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public ItemPlaceMove copy() {
        return this.copyExtras(new ItemPlaceMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static final class Type
    extends AbstractMove.Type<ItemPlaceMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<ItemPlaceMove>, ItemPlaceMove> buildCodec(RecordCodecBuilder.Instance<ItemPlaceMove> instance) {
            return this.baseDefault(instance, ItemPlaceMove::new);
        }
    }
}

