/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.GoldExperienceEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class BerryBushAttack
extends AbstractSimpleAttack<BerryBushAttack, GoldExperienceEntity> {
    private static final BlockState BERRY_BUSH = (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));

    public BerryBushAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NotNull
    public MoveType<BerryBushAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GoldExperienceEntity attacker, LivingEntity user) {
        BlockPos blockPos;
        Level world = attacker.m_9236_();
        if (world.m_8055_(blockPos = attacker.m_20183_()).m_60795_() && world.m_8055_(blockPos.m_7495_()).m_60815_()) {
            world.m_46597_(blockPos, BERRY_BUSH);
        }
        return super.perform(attacker, user);
    }

    @Override
    @NonNull
    protected BerryBushAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BerryBushAttack copy() {
        return this.copyExtras(new BerryBushAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<BerryBushAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<BerryBushAttack>, BerryBushAttack> buildCodec(RecordCodecBuilder.Instance<BerryBushAttack> instance) {
            return this.attackDefault(instance, BerryBushAttack::new);
        }
    }
}

