/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.GEButterflyEntity;
import net.arna.jcraft.common.entity.GEFrogEntity;
import net.arna.jcraft.common.entity.GESnakeEntity;
import net.arna.jcraft.common.entity.stand.GoldExperienceEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class LifeGiverAttack
extends AbstractMove<LifeGiverAttack, GoldExperienceEntity> {
    private LifeGiverType typeToSummon;

    public LifeGiverAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NotNull
    public MoveType<LifeGiverAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GoldExperienceEntity attacker, LivingEntity user) {
        ItemStack animalItem;
        Object animal;
        block16: {
            ItemStack item;
            block15: {
                item = user.m_21206_();
                if (item.m_41619_()) {
                    item = user.m_21205_();
                }
                if (item.m_41619_()) {
                    return Set.of();
                }
                animal = null;
                animalItem = item.m_41777_();
                animalItem.m_41764_(1);
                switch (this.typeToSummon.ordinal()) {
                    case 0: {
                        if (item.m_41741_() <= 1) {
                            return Set.of();
                        }
                        GESnakeEntity snake = new GESnakeEntity((EntityType<? extends TamableAnimal>)((EntityType)JEntityTypeRegistry.GE_SNAKE.get()), attacker.m_9236_());
                        if (user instanceof Player) {
                            Player playerEntity = (Player)user;
                            snake.m_21828_(playerEntity);
                        } else {
                            snake.m_7105_(true);
                            snake.m_21816_(user.m_20148_());
                        }
                        animal = snake;
                        break;
                    }
                    case 1: {
                        if (item.m_41741_() <= 1) {
                            return Set.of();
                        }
                        GEFrogEntity frog = new GEFrogEntity((EntityType<? extends Animal>)((EntityType)JEntityTypeRegistry.GE_FROG.get()), attacker.m_9236_());
                        frog.setMaster(user);
                        animal = frog;
                        break;
                    }
                    case 2: {
                        GEButterflyEntity butterfly = new GEButterflyEntity((EntityType<? extends FlyingMob>)((EntityType)JEntityTypeRegistry.GE_BUTTERFLY.get()), attacker.m_9236_());
                        butterfly.setMaster(user);
                        animal = butterfly;
                        break;
                    }
                    default: {
                        JCraft.LOGGER.error("Attempted to create Life Giver entity with invalid LifeGiverType: {}", (Object)this);
                    }
                }
                if (animal == null) {
                    JCraft.LOGGER.error("Failed to create animal of type {} from item {}", (Object)this.typeToSummon, (Object)animalItem);
                    return Set.of();
                }
                if (!(user instanceof Player)) break block15;
                Player player = (Player)user;
                if (player.m_150110_().f_35937_) break block16;
            }
            item.m_41774_(1);
        }
        animal.m_7678_(attacker.m_20185_(), attacker.m_20186_() + 0.5, attacker.m_20189_(), attacker.m_146908_(), attacker.m_146909_());
        animal.m_21008_(InteractionHand.MAIN_HAND, animalItem);
        attacker.m_9236_().m_7967_((Entity)animal);
        return Set.of();
    }

    @Override
    @NonNull
    protected LifeGiverAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LifeGiverAttack copy() {
        return this.copyExtras(new LifeGiverAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public void setTypeToSummon(LifeGiverType typeToSummon) {
        this.typeToSummon = typeToSummon;
    }

    public static class Type
    extends AbstractMove.Type<LifeGiverAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<LifeGiverAttack>, LifeGiverAttack> buildCodec(RecordCodecBuilder.Instance<LifeGiverAttack> instance) {
            return this.baseDefault(instance, LifeGiverAttack::new);
        }
    }

    public static enum LifeGiverType {
        SNAKE,
        FROG,
        BUTTERFLY;

    }
}

