/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.GoldExperienceEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class OverclockAttack
extends AbstractSimpleAttack<OverclockAttack, GoldExperienceEntity> {
    public OverclockAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.withStunType(StunType.LAUNCH);
        this.hitSpark = JParticleType.HIT_SPARK_3;
    }

    @Override
    @NotNull
    public MoveType<OverclockAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GoldExperienceEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        for (LivingEntity target : targets) {
            target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.DAZED.get(), 60, 3, true, false));
            target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.OUTOFBODY.get(), 60, 0, false, true));
            Vec3 upDir = new Vec3(GravityChangerAPI.getGravityDirection((Entity)user).m_253071_());
            JUtils.setVelocity((Entity)target, upDir.m_82490_(-0.8));
        }
        return targets;
    }

    @Override
    @NonNull
    protected OverclockAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public OverclockAttack copy() {
        return this.copyExtras(new OverclockAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<OverclockAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<OverclockAttack>, OverclockAttack> buildCodec(RecordCodecBuilder.Instance<OverclockAttack> instance) {
            return this.attackDefault(instance, OverclockAttack::new);
        }
    }
}

