/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.GETreeEntity;
import net.arna.jcraft.common.entity.stand.GoldExperienceEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class TreeAttack
extends AbstractSimpleAttack<TreeAttack, GoldExperienceEntity> {
    public TreeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.HIT_SPARK_2;
    }

    @Override
    @NotNull
    public MoveType<TreeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GoldExperienceEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        Vec3 direction = user.m_20154_();
        GETreeEntity tree = new GETreeEntity(attacker.m_9236_(), user, direction.m_82490_(1.33));
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)attacker);
        GravityChangerAPI.setDefaultGravityDirection((Entity)tree, gravity);
        Vec3 midPos = RotationUtil.vecPlayerToWorld(0.0, (double)attacker.m_20206_() * 0.25, 0.0, gravity);
        double e = direction.f_82479_;
        double f = direction.f_82480_;
        double g = direction.f_82481_;
        double l = direction.m_165924_();
        tree.m_7678_(attacker.m_20185_() + midPos.f_82479_, attacker.m_20186_() + midPos.f_82480_, attacker.m_20189_() + midPos.f_82481_, (float)(Mth.m_14136_((double)e, (double)g) * 57.2957763671875), (float)(Mth.m_14136_((double)f, (double)l) * 57.2957763671875));
        attacker.m_9236_().m_7967_((Entity)tree);
        return targets;
    }

    @Override
    @NonNull
    protected TreeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public TreeAttack copy() {
        return this.copyExtras(new TreeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<TreeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<TreeAttack>, TreeAttack> buildCodec(RecordCodecBuilder.Instance<TreeAttack> instance) {
            return this.attackDefault(instance, TreeAttack::new);
        }
    }
}

