/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience.requiem;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.GEREntity;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class FlightMove
extends AbstractMove<FlightMove, GEREntity> {
    private final int flightTime;

    public FlightMove(int cooldown, int windup, int duration, float moveDistance, int flightTime) {
        super(cooldown, windup, duration, moveDistance);
        this.flightTime = flightTime;
        this.mobilityType = MobilityType.FLIGHT;
    }

    @Override
    @NotNull
    public MoveType<FlightMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(GEREntity attacker) {
        this.tickFlight(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GEREntity attacker, LivingEntity user) {
        attacker.setFlightTime(this.flightTime);
        return Set.of();
    }

    public void tickFlight(GEREntity attacker) {
        if (!attacker.hasUser()) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        int flightTime = attacker.getFlightTime();
        attacker.setFlightTime(--flightTime);
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            if (!playerEntity.m_7500_() && !playerEntity.m_5833_()) {
                playerEntity.m_150110_().f_35935_ = flightTime > 1;
            }
        } else if (flightTime > 1) {
            Entity entity;
            double y = user.m_20186_();
            Vec3 vel = new Vec3(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
            LivingEntity targetEntity = null;
            CombatEntry mostDamagingOpponent = user.m_21231_().m_19298_();
            if (mostDamagingOpponent != null && (entity = mostDamagingOpponent.f_19250_().m_7639_()) instanceof LivingEntity) {
                LivingEntity livingTarget;
                targetEntity = livingTarget = (LivingEntity)entity;
            }
            if (targetEntity == null && user instanceof Mob) {
                Mob mob = (Mob)user;
                targetEntity = mob.m_5448_();
            }
            if (targetEntity == null) {
                targetEntity = user.m_21188_();
            }
            Vec3 target = targetEntity != null ? targetEntity.m_146892_() : attacker.m_20182_().m_82520_(Math.sin((double)attacker.f_19797_ * 0.2) * 3.0, 0.0, Math.cos((double)attacker.f_19797_ * 0.2) * 3.0);
            double dY = Mth.m_14008_((double)(target.m_7098_() - y), (double)-1.0, (double)1.0);
            vel = vel.m_82549_(target.m_82546_(user.m_20182_()).m_82541_()).m_82490_(0.4);
            user.m_20256_(vel);
            user.m_20343_(user.m_20185_(), y += dY, user.m_20189_());
            user.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 5, 1, true, false));
        }
    }

    @Override
    @NonNull
    protected FlightMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public FlightMove copy() {
        return this.copyExtras(new FlightMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getFlightTime()));
    }

    public int getFlightTime() {
        return this.flightTime;
    }

    public static class Type
    extends AbstractMove.Type<FlightMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<FlightMove>, FlightMove> buildCodec(RecordCodecBuilder.Instance<FlightMove> instance) {
            return this.baseDefault(instance).and((App)ExtraCodecs.f_144628_.fieldOf("flight_time").forGetter(FlightMove::getFlightTime)).apply(instance, this.applyExtras(FlightMove::new));
        }
    }
}

