/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience.requiem;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.GERScorpionEntity;
import net.arna.jcraft.common.entity.stand.GEREntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class LifeBeamAttack
extends AbstractMove<LifeBeamAttack, GEREntity> {
    public LifeBeamAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NotNull
    public MoveType<LifeBeamAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GEREntity attacker, LivingEntity user) {
        GERScorpionEntity scorpion = new GERScorpionEntity((EntityType<? extends Mob>)((EntityType)JEntityTypeRegistry.GER_SCORPION.get()), attacker.m_9236_());
        if (this.getChargeTime() >= 18) {
            scorpion.charge();
        }
        scorpion.setInitialVel(user.m_20154_().m_82490_(2.0));
        Vec3 ePos = attacker.m_146892_();
        scorpion.m_7678_(ePos.f_82479_, ePos.f_82480_, ePos.f_82481_, -user.m_146908_() - 90.0f, attacker.m_146909_());
        scorpion.setMaster(user);
        attacker.m_9236_().m_7967_((Entity)scorpion);
        return Set.of();
    }

    @Override
    @NonNull
    protected LifeBeamAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LifeBeamAttack copy() {
        return this.copyExtras(new LifeBeamAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<LifeBeamAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<LifeBeamAttack>, LifeBeamAttack> buildCodec(RecordCodecBuilder.Instance<LifeBeamAttack> instance) {
            return this.baseDefault(instance, LifeBeamAttack::new);
        }
    }
}

