/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience.requiem;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.GEREntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class NullificationAttack
extends AbstractCounterAttack<NullificationAttack, GEREntity> {
    private static final int COUNTER_STOP_TIME = 20;
    private final CounterMissMove<GEREntity> counterMiss = new CounterMissMove(20);

    public NullificationAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<NullificationAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void whiff(@NonNull GEREntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.setMove(this.counterMiss, GEREntity.State.COUNTER_MISS);
        JCraft.stun(attacker.getUser(), this.counterMiss.getDuration(), 0);
    }

    @Override
    public void counter(@NonNull GEREntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        if (countered == null || !attacker.hasUser()) {
            return;
        }
        JComponentPlatformUtils.getTimeStopData(countered).ifPresent(t -> t.setTicks(20));
        if (countered instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)countered;
            JCraft.stun(living, 10, 0);
            JUtils.cancelMoves(living);
        }
        Vec3 eP = attacker.m_146892_();
        JCraft.createParticle((ServerLevel)attacker.m_9236_(), eP.f_82479_, eP.f_82480_, eP.f_82481_, JParticleType.FLASH);
    }

    @Override
    @NonNull
    protected NullificationAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public NullificationAttack copy() {
        return this.copyExtras(new NullificationAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<NullificationAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<NullificationAttack>, NullificationAttack> buildCodec(RecordCodecBuilder.Instance<NullificationAttack> instance) {
            return this.baseDefault(instance, NullificationAttack::new);
        }
    }
}

