/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience.requiem;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.GEREntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class OverheadKickAttack
extends AbstractSimpleAttack<OverheadKickAttack, GEREntity> {
    public OverheadKickAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.HIT_SPARK_3;
    }

    @Override
    protected void processTarget(GEREntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        JUtils.addVelocity((Entity)target, 0.0, -1.0, 0.0);
        target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 23, false, false));
    }

    @Override
    @NotNull
    public MoveType<OverheadKickAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected OverheadKickAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public OverheadKickAttack copy() {
        return this.copyExtras(new OverheadKickAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<OverheadKickAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<OverheadKickAttack>, OverheadKickAttack> buildCodec(RecordCodecBuilder.Instance<OverheadKickAttack> instance) {
            return this.attackDefault(instance, OverheadKickAttack::new);
        }
    }
}

