/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.goldexperience.requiem;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.GEREntity;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class ReturnToZeroMove
extends AbstractMove<ReturnToZeroMove, GEREntity> {
    private final Map<Entity, CompoundTag> entityData = new WeakHashMap<Entity, CompoundTag>();
    private final List<ReturnData> returnInfo = new ArrayList<ReturnData>();

    public ReturnToZeroMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<ReturnToZeroMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(GEREntity attacker) {
        this.tickReturnInfo(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(GEREntity attacker, LivingEntity user) {
        List toReturn = attacker.m_9236_().m_6443_(Entity.class, attacker.m_20191_().m_82400_(64.0), EntitySelector.f_20406_.and(e -> e != attacker && e != user));
        for (Entity e2 : toReturn) {
            CompoundTag data = new CompoundTag();
            e2.m_20240_(data);
            this.entityData.put(e2, data);
            this.returnInfo.add(new ReturnData(e2.m_146892_(), e2));
        }
        return Set.of();
    }

    private void applyModernNBT(CompoundTag receiver, CompoundTag sender, Set<String> identifiers) {
        for (String identifier : identifiers) {
            if (!sender.m_128441_(identifier)) continue;
            receiver.m_128365_(identifier, Objects.requireNonNull(sender.m_128423_(identifier)));
        }
    }

    public boolean returnToZero(GEREntity attacker) {
        if (this.entityData.isEmpty()) {
            return false;
        }
        for (Map.Entry<Entity, CompoundTag> data : this.entityData.entrySet()) {
            Entity ent = data.getKey();
            if (!ent.m_6084_()) continue;
            CompoundTag nbt = data.getValue();
            if (ent instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)ent;
                nbt.m_128365_("Inventory", (Tag)serverPlayer.m_150109_().m_36026_(new ListTag()));
                nbt.m_128365_("EnderItems", (Tag)serverPlayer.m_36327_().m_7927_());
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(ent));
                ListTag list = nbt.m_128437_("Pos", 6);
                serverPlayer.m_20324_(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
            } else {
                CompoundTag modernNbt = new CompoundTag();
                ent.m_20240_(modernNbt);
                this.applyModernNBT(nbt, modernNbt, Set.of("Items", "Inventory", "HandItems", "ArmorItems"));
            }
            ent.m_20258_(nbt);
        }
        this.entityData.clear();
        this.returnInfo.clear();
        attacker.m_5496_((SoundEvent)JSoundRegistry.GER_RTZ.get(), 1.0f, 1.0f);
        return true;
    }

    public void tickReturnInfo(GEREntity attacker) {
        LivingEntity livingEntity = attacker.getUser();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        for (ReturnData data : this.returnInfo) {
            Entity entity = data.entity();
            if (entity == null || !entity.m_6084_()) continue;
            Vec3 position = data.originalPos();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeShort(7);
            buf.writeInt(entity.m_19879_());
            buf.writeDouble(position.m_7096_());
            buf.writeDouble(position.m_7098_());
            buf.writeDouble(position.m_7094_());
            ServerChannelFeedbackPacket.send(serverPlayer, buf);
        }
    }

    @Override
    @NonNull
    protected ReturnToZeroMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public ReturnToZeroMove copy() {
        return this.copyExtras(new ReturnToZeroMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<ReturnToZeroMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<ReturnToZeroMove>, ReturnToZeroMove> buildCodec(RecordCodecBuilder.Instance<ReturnToZeroMove> instance) {
            return this.baseDefault(instance, ReturnToZeroMove::new);
        }
    }

    record ReturnData(Vec3 originalPos, Entity entity) {
    }
}

