/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.hierophantgreen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.common.entity.projectile.EmeraldProjectile;
import net.arna.jcraft.common.entity.stand.HGEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class EmeraldSplashAttack
extends AbstractMultiHitAttack<EmeraldSplashAttack, HGEntity> {
    private final float speed;
    private final boolean isSuper;
    private boolean reflect = false;

    public EmeraldSplashAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float knockback, float offset, IntSet hitMoments, float speed, boolean isSuper) {
        super(cooldown, duration, moveDistance, damage, stun, 0.0f, knockback, offset, (IntCollection)hitMoments);
        this.speed = speed;
        this.isSuper = isSuper;
        this.ranged = true;
    }

    public EmeraldSplashAttack withReflect() {
        return this.withReflect(true);
    }

    public EmeraldSplashAttack withReflect(boolean reflect) {
        this.reflect = reflect;
        return this;
    }

    @Override
    @NotNull
    public MoveType<EmeraldSplashAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HGEntity attacker, LivingEntity user) {
        int emeraldCount = 3 + this.getChargeTime() / 10;
        for (int i = 0; i < emeraldCount; ++i) {
            EmeraldProjectile emerald = new EmeraldProjectile(attacker.m_9236_(), user);
            emerald.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, this.speed, 5.0f);
            Vec3 heightOffset = GravityChangerAPI.getEyeOffset((Entity)user).m_82490_(0.75);
            emerald.m_146884_(attacker.getBaseEntity().m_20182_().m_82549_(heightOffset));
            if (this.reflect) {
                emerald.withReflect();
            }
            attacker.m_9236_().m_7967_((Entity)emerald);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected EmeraldSplashAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public EmeraldSplashAttack copy() {
        EmeraldSplashAttack emeraldSplashAttack = this.copyExtras(new EmeraldSplashAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getKnockback(), this.getOffset(), (IntSet)this.getHitMoments(), this.speed, this.isSuper));
        if (this.reflect) {
            emeraldSplashAttack.withReflect();
        }
        return emeraldSplashAttack;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean isReflect() {
        return this.reflect;
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<EmeraldSplashAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<EmeraldSplashAttack>, EmeraldSplashAttack> buildCodec(RecordCodecBuilder.Instance<EmeraldSplashAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.knockback(), this.offset(), this.hitMoments(), (App)Codec.FLOAT.fieldOf("speed").forGetter(EmeraldSplashAttack::getSpeed), (App)Codec.BOOL.fieldOf("is_super").forGetter(EmeraldSplashAttack::isSuper), (App)Codec.BOOL.optionalFieldOf("reflect", (Object)false).forGetter(EmeraldSplashAttack::isReflect)).apply(instance, this.applyAttackExtras((cooldown, duration, moveDistance, damage, stun, knockback, offset, hitMoments, speed, isSuper, reflect) -> new EmeraldSplashAttack((int)cooldown, (int)duration, moveDistance.floatValue(), damage.floatValue(), (int)stun, knockback.floatValue(), offset.floatValue(), (IntSet)hitMoments, speed.floatValue(), (boolean)isSuper).withReflect((boolean)reflect)));
        }
    }
}

