/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.hierophantgreen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.HGNetEntity;
import net.arna.jcraft.common.entity.stand.HGEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class NetSetMove
extends AbstractMove<NetSetMove, HGEntity> {
    public NetSetMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<NetSetMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HGEntity attacker, LivingEntity user) {
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)attacker);
        HGNetEntity net = new HGNetEntity(attacker.m_9236_());
        net.setSkin(attacker.getSkin());
        net.m_7678_(attacker.m_20185_() + (double)gravity.m_122429_(), attacker.m_20186_() + (double)gravity.m_122430_(), attacker.m_20189_() + (double)gravity.m_122431_(), attacker.m_217043_().m_188501_() * 360.0f, attacker.m_217043_().m_188501_() * 360.0f);
        net.setMaster(user);
        attacker.m_9236_().m_7967_((Entity)net);
        GravityChangerAPI.addGravity((Entity)net, new Gravity(gravity, 0, Short.MAX_VALUE, "_spawn"));
        return Set.of();
    }

    @Override
    @NonNull
    protected NetSetMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public NetSetMove copy() {
        return this.copyExtras(new NetSetMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<NetSetMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<NetSetMove>, NetSetMove> buildCodec(RecordCodecBuilder.Instance<NetSetMove> instance) {
            return this.baseDefault(instance, NetSetMove::new);
        }
    }
}

