/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.common.entity.projectile.IcicleProjectile;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class HorusBarrageAttack
extends AbstractBarrageAttack<HorusBarrageAttack, HorusEntity> {
    public HorusBarrageAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
        this.withHoldable();
    }

    @Override
    @NotNull
    public MoveType<HorusBarrageAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        IcicleProjectile icicle = new IcicleProjectile(attacker.m_9236_(), user);
        icicle.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.75f, 0.1f);
        Vec3 heightOffset = GravityChangerAPI.getEyeOffset((Entity)user).m_82490_(0.75);
        icicle.m_146884_(attacker.getBaseEntity().m_20182_().m_82549_(heightOffset).m_82520_(attacker.m_217043_().m_188583_() / 3.0, attacker.m_217043_().m_188583_() / 3.0, attacker.m_217043_().m_188583_() / 3.0));
        attacker.m_9236_().m_7967_((Entity)icicle);
        return targets;
    }

    @Override
    public void onUserMoveInput(HorusEntity attacker, MoveInputType type, boolean pressed, boolean moveInitiated) {
        super.onUserMoveInput(attacker, type, pressed, moveInitiated);
        if (type.getMoveClass() == this.getMoveClass() && !pressed) {
            attacker.cancelMove();
        }
    }

    @Override
    @NonNull
    protected HorusBarrageAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public HorusBarrageAttack copy() {
        return this.copyExtras(new HorusBarrageAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getInterval()));
    }

    public static class Type
    extends AbstractBarrageAttack.Type<HorusBarrageAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<HorusBarrageAttack>, HorusBarrageAttack> buildCodec(RecordCodecBuilder.Instance<HorusBarrageAttack> instance) {
            return this.barrageDefault(instance, HorusBarrageAttack::new);
        }
    }
}

