/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.minecraft.world.entity.LivingEntity;

public class HorusDetonateAttack
extends AbstractMove<HorusDetonateAttack, HorusEntity> {
    public HorusDetonateAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<HorusDetonateAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(HorusEntity attacker) {
        return super.conditionsMet(attacker) && attacker.getLastLargeIcicle() != null;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        attacker.getLastLargeIcicle().detonate();
        return Set.of();
    }

    @Override
    @NonNull
    protected HorusDetonateAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public HorusDetonateAttack copy() {
        return this.copyExtras(new HorusDetonateAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<HorusDetonateAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<HorusDetonateAttack>, HorusDetonateAttack> buildCodec(RecordCodecBuilder.Instance<HorusDetonateAttack> instance) {
            return this.baseDefault(instance, HorusDetonateAttack::new);
        }
    }
}

